/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.PopmoneyAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class PopmoneyAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("USD"));

    public PopmoneyAccount() {
        super(PaymentMethod.POPMONEY);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new PopmoneyAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    public void setAccountId(String accountId) {
        ((PopmoneyAccountPayload)this.paymentAccountPayload).setAccountId(accountId);
    }

    public String getAccountId() {
        return ((PopmoneyAccountPayload)this.paymentAccountPayload).getAccountId();
    }

    public void setHolderName(String holderName) {
        ((PopmoneyAccountPayload)this.paymentAccountPayload).setHolderName(holderName);
    }

    public String getHolderName() {
        return ((PopmoneyAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopmoneyAccount)) {
            return false;
        }
        PopmoneyAccount other = (PopmoneyAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PopmoneyAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

