/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.offer.Offer;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.ReceiptPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReceiptValidator {
    private static final Logger log = LoggerFactory.getLogger(ReceiptValidator.class);
    private final ReceiptPredicates predicates;
    private final PaymentAccount account;
    private final Offer offer;

    ReceiptValidator(Offer offer, PaymentAccount account) {
        this(offer, account, new ReceiptPredicates());
    }

    ReceiptValidator(Offer offer, PaymentAccount account, ReceiptPredicates predicates) {
        this.offer = offer;
        this.account = account;
        this.predicates = predicates;
    }

    boolean isValid() {
        if (!this.predicates.isMatchingCurrency(this.offer, this.account)) {
            return false;
        }
        boolean isEqualPaymentMethods = this.predicates.isEqualPaymentMethods(this.offer, this.account);
        if (!(this.account instanceof CountryBasedPaymentAccount)) {
            return isEqualPaymentMethods;
        }
        if (!this.predicates.isMatchingCountryCodes(this.offer, this.account)) {
            return false;
        }
        if (this.predicates.isMatchingSepaOffer(this.offer, this.account)) {
            return true;
        }
        if (this.predicates.isMatchingSepaInstant(this.offer, this.account)) {
            return true;
        }
        if (!isEqualPaymentMethods) {
            return false;
        }
        if (this.predicates.isOfferRequireSameOrSpecificBank(this.offer, this.account)) {
            return this.predicates.isMatchingBankId(this.offer, this.account);
        }
        return true;
    }
}

