/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.RevolutAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class RevolutAccount
extends PaymentAccount {
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.USERNAME, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AED"), new TraditionalCurrency("AUD"), new TraditionalCurrency("BGN"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CHF"), new TraditionalCurrency("CZK"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("HKD"), new TraditionalCurrency("HUF"), new TraditionalCurrency("ILS"), new TraditionalCurrency("ISK"), new TraditionalCurrency("JPY"), new TraditionalCurrency("MAD"), new TraditionalCurrency("MXN"), new TraditionalCurrency("NOK"), new TraditionalCurrency("NZD"), new TraditionalCurrency("PLN"), new TraditionalCurrency("QAR"), new TraditionalCurrency("RON"), new TraditionalCurrency("RSD"), new TraditionalCurrency("RUB"), new TraditionalCurrency("SAR"), new TraditionalCurrency("SEK"), new TraditionalCurrency("SGD"), new TraditionalCurrency("THB"), new TraditionalCurrency("TRY"), new TraditionalCurrency("USD"), new TraditionalCurrency("ZAR"));

    public RevolutAccount() {
        super(PaymentMethod.REVOLUT);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new RevolutAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setUsername(String userame) {
        this.revolutAccountPayload().setUserName(userame);
    }

    public String getUsername() {
        return this.revolutAccountPayload().getUsername();
    }

    public boolean usernameNotSet() {
        return this.revolutAccountPayload().usernameNotSet();
    }

    private RevolutAccountPayload revolutAccountPayload() {
        return (RevolutAccountPayload)this.paymentAccountPayload;
    }

    @Override
    public void onAddToUser() {
        super.onAddToUser();
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolutAccount)) {
            return false;
        }
        RevolutAccount other = (RevolutAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolutAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

