/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.SatispayAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class SatispayAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("EUR"));

    public SatispayAccount() {
        super(PaymentMethod.SATISPAY);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new SatispayAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setHolderName(String accountId) {
        ((SatispayAccountPayload)this.paymentAccountPayload).setHolderName(accountId);
    }

    public String getHolderName() {
        return ((SatispayAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setMobileNr(String accountId) {
        ((SatispayAccountPayload)this.paymentAccountPayload).setMobileNr(accountId);
    }

    public String getMobileNr() {
        return ((SatispayAccountPayload)this.paymentAccountPayload).getMobileNr();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.satispay.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.satispay.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.satispay.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SatispayAccount)) {
            return false;
        }
        SatispayAccount other = (SatispayAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SatispayAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

