/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.util.MathUtils;
import haveno.core.trade.HavenoUtils;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeLimits {
    private static final Logger log = LoggerFactory.getLogger(TradeLimits.class);
    private static final BigInteger MAX_TRADE_LIMIT = HavenoUtils.xmrToAtomicUnits(528.0);
    private static final BigInteger MAX_TRADE_LIMIT_WITHOUT_BUYER_AS_TAKER_DEPOSIT = HavenoUtils.xmrToAtomicUnits(1.5);
    @Nullable
    private static TradeLimits INSTANCE;

    @Inject
    public TradeLimits() {
        INSTANCE = this;
    }

    public void onAllServicesInitialized() {
    }

    public BigInteger getMaxTradeLimit() {
        return MAX_TRADE_LIMIT;
    }

    public BigInteger getMaxTradeLimitBuyerAsTakerWithoutDeposit() {
        return MAX_TRADE_LIMIT_WITHOUT_BUYER_AS_TAKER_DEPOSIT;
    }

    public long getRoundedRiskBasedTradeLimit(long maxLimit, long riskFactor) {
        return this.getFirstMonthRiskBasedTradeLimit(maxLimit, riskFactor) * 4L;
    }

    @VisibleForTesting
    long getFirstMonthRiskBasedTradeLimit(long maxLimit, long riskFactor) {
        long smallestLimit = maxLimit / (4L * riskFactor);
        double decimalForm = MathUtils.scaleDownByPowerOf10((double)smallestLimit, 8);
        double rounded = MathUtils.roundDouble(decimalForm, 4);
        return MathUtils.roundDoubleToLong(MathUtils.scaleUpByPowerOf10(rounded, 8));
    }

    @Nullable
    public static TradeLimits getINSTANCE() {
        return INSTANCE;
    }
}

