/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.TransferwiseUsdAccountPayload;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TransferwiseUsdAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("USD"));

    public TransferwiseUsdAccount() {
        super(PaymentMethod.TRANSFERWISE_USD);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new TransferwiseUsdAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setEmail(String email) {
        ((TransferwiseUsdAccountPayload)this.paymentAccountPayload).setEmail(email);
    }

    public String getEmail() {
        return ((TransferwiseUsdAccountPayload)this.paymentAccountPayload).getEmail();
    }

    public void setHolderName(String accountId) {
        ((TransferwiseUsdAccountPayload)this.paymentAccountPayload).setHolderName(accountId);
    }

    public String getHolderName() {
        return ((TransferwiseUsdAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setBeneficiaryAddress(String address) {
        ((TransferwiseUsdAccountPayload)this.paymentAccountPayload).setBeneficiaryAddress(address);
    }

    public String getBeneficiaryAddress() {
        return ((TransferwiseUsdAccountPayload)this.paymentAccountPayload).getBeneficiaryAddress();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.transferwiseUsd.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.transferwiseUsd.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.transferwiseUsd.info.account";
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferwiseUsdAccount)) {
            return false;
        }
        TransferwiseUsdAccount other = (TransferwiseUsdAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TransferwiseUsdAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

