/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.VenmoAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class VenmoAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("USD"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.EMAIL_OR_MOBILE_NR_OR_USERNAME, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);

    public VenmoAccount() {
        super(PaymentMethod.VENMO);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new VenmoAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setNameOrUsernameOrEmailOrMobileNr(String usernameOrEmailOrMobileNr) {
        ((VenmoAccountPayload)this.paymentAccountPayload).setEmailOrMobileNrOrUsername(usernameOrEmailOrMobileNr);
    }

    public String getNameOrUsernameOrEmailOrMobileNr() {
        return ((VenmoAccountPayload)this.paymentAccountPayload).getEmailOrMobileNrOrUsername();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VenmoAccount)) {
            return false;
        }
        VenmoAccount other = (VenmoAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VenmoAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

