/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.VerseAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class VerseAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("DKK"), new TraditionalCurrency("EUR"), new TraditionalCurrency("HUF"), new TraditionalCurrency("PLN"), new TraditionalCurrency("SEK"));

    public VerseAccount() {
        super(PaymentMethod.VERSE);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new VerseAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setHolderName(String accountId) {
        ((VerseAccountPayload)this.paymentAccountPayload).setHolderName(accountId);
    }

    public String getHolderName() {
        return ((VerseAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.verse.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.verse.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.verse.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerseAccount)) {
            return false;
        }
        VerseAccount other = (VerseAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VerseAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

