/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.WeChatPayAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class WeChatPayAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("CNY"), new TraditionalCurrency("USD"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"));

    public WeChatPayAccount() {
        super(PaymentMethod.WECHAT_PAY);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new WeChatPayAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    public void setAccountNr(String accountNr) {
        ((WeChatPayAccountPayload)this.paymentAccountPayload).setAccountNr(accountNr);
    }

    public String getAccountNr() {
        return ((WeChatPayAccountPayload)this.paymentAccountPayload).getAccountNr();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeChatPayAccount)) {
            return false;
        }
        WeChatPayAccount other = (WeChatPayAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WeChatPayAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

