/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.WesternUnionAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class WesternUnionAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = CurrencyUtil.getAllFiatCurrencies();

    public WesternUnionAccount() {
        super(PaymentMethod.WESTERN_UNION);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new WesternUnionAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    public String getEmail() {
        return ((WesternUnionAccountPayload)this.paymentAccountPayload).getEmail();
    }

    public void setEmail(String email) {
        ((WesternUnionAccountPayload)this.paymentAccountPayload).setEmail(email);
    }

    public String getFullName() {
        return ((WesternUnionAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setFullName(String email) {
        ((WesternUnionAccountPayload)this.paymentAccountPayload).setHolderName(email);
    }

    public String getCity() {
        return ((WesternUnionAccountPayload)this.paymentAccountPayload).getCity();
    }

    public void setCity(String email) {
        ((WesternUnionAccountPayload)this.paymentAccountPayload).setCity(email);
    }

    public String getState() {
        return ((WesternUnionAccountPayload)this.paymentAccountPayload).getState();
    }

    public void setState(String email) {
        ((WesternUnionAccountPayload)this.paymentAccountPayload).setState(email);
    }
}

