/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.common.util.JsonExclude;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AmazonGiftCardAccountPayload;

public class AmazonGiftCardAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(AmazonGiftCardAccountPayload.class);
    private String emailOrMobileNr;
    @JsonExclude
    private String countryCode = "";

    public AmazonGiftCardAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private AmazonGiftCardAccountPayload(String paymentMethodName, String id, String emailOrMobileNr, String countryCode, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNr = emailOrMobileNr;
        this.countryCode = countryCode;
    }

    @Override
    public Message toProtoMessage() {
        AmazonGiftCardAccountPayload.Builder builder = protobuf.AmazonGiftCardAccountPayload.newBuilder().setCountryCode(this.countryCode).setEmailOrMobileNr(this.emailOrMobileNr);
        return this.getPaymentAccountPayloadBuilder().setAmazonGiftCardAccountPayload(builder).build();
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.AmazonGiftCardAccountPayload amazonGiftCardAccountPayload = proto.getAmazonGiftCardAccountPayload();
        return new AmazonGiftCardAccountPayload(proto.getPaymentMethodId(), proto.getId(), amazonGiftCardAccountPayload.getEmailOrMobileNr(), amazonGiftCardAccountPayload.getCountryCode(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.email.mobile") + " " + this.emailOrMobileNr;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String data = "AmazonGiftCard" + this.emailOrMobileNr;
        return super.getAgeWitnessInputData(data.getBytes(StandardCharsets.UTF_8));
    }

    public boolean countryNotSet() {
        return this.countryCode.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmazonGiftCardAccountPayload)) {
            return false;
        }
        AmazonGiftCardAccountPayload other = (AmazonGiftCardAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNr = this.getEmailOrMobileNr();
        String other$emailOrMobileNr = other.getEmailOrMobileNr();
        if (this$emailOrMobileNr == null ? other$emailOrMobileNr != null : !this$emailOrMobileNr.equals(other$emailOrMobileNr)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        return !(this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AmazonGiftCardAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNr = this.getEmailOrMobileNr();
        result = result * 59 + ($emailOrMobileNr == null ? 43 : $emailOrMobileNr.hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AmazonGiftCardAccountPayload(emailOrMobileNr=" + this.getEmailOrMobileNr() + ", countryCode=" + this.getCountryCode() + ")";
    }

    public void setEmailOrMobileNr(String emailOrMobileNr) {
        this.emailOrMobileNr = emailOrMobileNr;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getEmailOrMobileNr() {
        return this.emailOrMobileNr;
    }

    public String getCountryCode() {
        return this.countryCode;
    }
}

