/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssetAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(AssetAccountPayload.class);
    protected String address = "";

    protected AssetAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    protected AssetAccountPayload(String paymentMethod, String id, String address, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.address = address;
    }

    @Override
    public String getPaymentDetails() {
        return Res.getWithCol("payment.crypto.receiver.address") + " " + this.address;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.address.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetAccountPayload)) {
            return false;
        }
        AssetAccountPayload other = (AssetAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AssetAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AssetAccountPayload(address=" + this.getAddress() + ")";
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }
}

