/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.common.util.CollectionUtils;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AustraliaPayidPayload;

public final class AustraliaPayidAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(AustraliaPayidAccountPayload.class);
    private String payid = "";
    private String bankAccountName = "";
    private String extraInfo = "";

    public AustraliaPayidAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private AustraliaPayidAccountPayload(String paymentMethod, String id, String payid, String bankAccountName, String extraInfo, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.payid = payid;
        this.bankAccountName = bankAccountName;
        this.extraInfo = extraInfo;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setAustraliaPayidPayload(AustraliaPayidPayload.newBuilder().setPayid(this.payid).setBankAccountName(this.bankAccountName).setExtraInfo(this.extraInfo)).build();
    }

    public static AustraliaPayidAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        AustraliaPayidPayload AustraliaPayidPayload2 = proto.getAustraliaPayidPayload();
        return new AustraliaPayidAccountPayload(proto.getPaymentMethodId(), proto.getId(), AustraliaPayidPayload2.getPayid(), AustraliaPayidPayload2.getBankAccountName(), AustraliaPayidPayload2.getExtraInfo(), proto.getMaxTradePeriod(), (Map<String, String>)(CollectionUtils.isEmpty(proto.getExcludeFromJsonDataMap()) ? null : new HashMap<String, String>(proto.getExcludeFromJsonDataMap())));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.get("payment.australia.payid") + ": " + this.payid + "\n" + Res.get("payment.account.owner") + ": " + this.bankAccountName + "\n" + Res.get("payment.shared.extraInfo") + ": " + this.extraInfo;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String all = this.payid + this.bankAccountName;
        return super.getAgeWitnessInputData(all.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AustraliaPayidAccountPayload)) {
            return false;
        }
        AustraliaPayidAccountPayload other = (AustraliaPayidAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$payid = this.getPayid();
        String other$payid = other.getPayid();
        if (this$payid == null ? other$payid != null : !this$payid.equals(other$payid)) {
            return false;
        }
        String this$bankAccountName = this.getBankAccountName();
        String other$bankAccountName = other.getBankAccountName();
        if (this$bankAccountName == null ? other$bankAccountName != null : !this$bankAccountName.equals(other$bankAccountName)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AustraliaPayidAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $payid = this.getPayid();
        result = result * 59 + ($payid == null ? 43 : $payid.hashCode());
        String $bankAccountName = this.getBankAccountName();
        result = result * 59 + ($bankAccountName == null ? 43 : $bankAccountName.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AustraliaPayidAccountPayload(payid=" + this.getPayid() + ", bankAccountName=" + this.getBankAccountName() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public void setPayid(String payid) {
        this.payid = payid;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getPayid() {
        return this.payid;
    }

    public String getBankAccountName() {
        return this.bankAccountName;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

