/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import haveno.core.locale.BankUtil;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import haveno.core.payment.payload.PayloadWithHolderName;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.BankAccountPayload;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;

public abstract class BankAccountPayload
extends CountryBasedPaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(BankAccountPayload.class);
    protected String holderName = "";
    protected String bankName = "";
    protected String branchId = "";
    protected String accountNr = "";
    @Nullable
    protected String accountType;
    @Nullable
    protected String holderTaxId;
    protected String bankId = "";
    @Nullable
    protected String nationalAccountId;

    protected BankAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    protected BankAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, @Nullable String bankName, @Nullable String branchId, @Nullable String accountNr, @Nullable String accountType, @Nullable String holderTaxId, @Nullable String bankId, @Nullable String nationalAccountId, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.bankName = bankName;
        this.branchId = branchId;
        this.accountNr = accountNr;
        this.accountType = accountType;
        this.holderTaxId = holderTaxId;
        this.bankId = bankId;
        this.nationalAccountId = nationalAccountId;
    }

    @Override
    public PaymentAccountPayload.Builder getPaymentAccountPayloadBuilder() {
        BankAccountPayload.Builder builder = protobuf.BankAccountPayload.newBuilder().setHolderName(this.holderName);
        Optional.ofNullable(this.holderTaxId).ifPresent(builder::setHolderTaxId);
        Optional.ofNullable(this.bankName).ifPresent(builder::setBankName);
        Optional.ofNullable(this.branchId).ifPresent(builder::setBranchId);
        Optional.ofNullable(this.accountNr).ifPresent(builder::setAccountNr);
        Optional.ofNullable(this.accountType).ifPresent(builder::setAccountType);
        Optional.ofNullable(this.bankId).ifPresent(builder::setBankId);
        Optional.ofNullable(this.nationalAccountId).ifPresent(builder::setNationalAccountId);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = super.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setBankAccountPayload(builder);
        return super.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder);
    }

    @Override
    public String getPaymentDetails() {
        return "Bank account transfer - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        String bankName = BankUtil.isBankNameRequired(this.countryCode) ? BankUtil.getBankNameLabel(this.countryCode) + ": " + this.bankName + "\n" : "";
        String bankId = BankUtil.isBankIdRequired(this.countryCode) ? BankUtil.getBankIdLabel(this.countryCode) + ": " + this.bankId + "\n" : "";
        String branchId = BankUtil.isBranchIdRequired(this.countryCode) ? BankUtil.getBranchIdLabel(this.countryCode) + ": " + this.branchId + "\n" : "";
        String nationalAccountId = BankUtil.isNationalAccountIdRequired(this.countryCode) ? BankUtil.getNationalAccountIdLabel(this.countryCode) + ": " + this.nationalAccountId + "\n" : "";
        String accountNr = BankUtil.isAccountNrRequired(this.countryCode) ? BankUtil.getAccountNrLabel(this.countryCode) + ": " + this.accountNr + "\n" : "";
        String accountType = BankUtil.isAccountTypeRequired(this.countryCode) ? BankUtil.getAccountTypeLabel(this.countryCode) + ": " + this.accountType + "\n" : "";
        String holderTaxIdString = BankUtil.isHolderIdRequired(this.countryCode) ? BankUtil.getHolderIdLabel(this.countryCode) + ": " + this.holderTaxId + "\n" : "";
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + bankName + bankId + branchId + nationalAccountId + accountNr + accountType + holderTaxIdString + Res.getWithCol("payment.bank.country") + " " + CountryUtil.getNameByCode(this.countryCode);
    }

    protected String getHolderIdLabel() {
        return BankUtil.getHolderIdLabel(this.countryCode);
    }

    @Nullable
    public String getBankId() {
        return BankUtil.isBankIdRequired(this.countryCode) ? this.bankId : this.bankName;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String bankName = BankUtil.isBankNameRequired(this.countryCode) ? this.bankName : "";
        String bankId = BankUtil.isBankIdRequired(this.countryCode) ? this.bankId : "";
        String branchId = BankUtil.isBranchIdRequired(this.countryCode) ? this.branchId : "";
        String accountNr = BankUtil.isAccountNrRequired(this.countryCode) ? this.accountNr : "";
        String accountType = BankUtil.isAccountTypeRequired(this.countryCode) ? this.accountType : "";
        String holderTaxIdString = BankUtil.isHolderIdRequired(this.countryCode) ? BankUtil.getHolderIdLabel(this.countryCode) + " " + this.holderTaxId + "\n" : "";
        String nationalAccountId = BankUtil.isNationalAccountIdRequired(this.countryCode) ? this.nationalAccountId : "";
        String all = bankName + bankId + branchId + accountNr + accountType + holderTaxIdString + nationalAccountId;
        return super.getAgeWitnessInputData(all.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccountPayload)) {
            return false;
        }
        BankAccountPayload other = (BankAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        String this$branchId = this.getBranchId();
        String other$branchId = other.getBranchId();
        if (this$branchId == null ? other$branchId != null : !this$branchId.equals(other$branchId)) {
            return false;
        }
        String this$accountNr = this.getAccountNr();
        String other$accountNr = other.getAccountNr();
        if (this$accountNr == null ? other$accountNr != null : !this$accountNr.equals(other$accountNr)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        String this$holderTaxId = this.getHolderTaxId();
        String other$holderTaxId = other.getHolderTaxId();
        if (this$holderTaxId == null ? other$holderTaxId != null : !this$holderTaxId.equals(other$holderTaxId)) {
            return false;
        }
        String this$bankId = this.getBankId();
        String other$bankId = other.getBankId();
        if (this$bankId == null ? other$bankId != null : !this$bankId.equals(other$bankId)) {
            return false;
        }
        String this$nationalAccountId = this.getNationalAccountId();
        String other$nationalAccountId = other.getNationalAccountId();
        return !(this$nationalAccountId == null ? other$nationalAccountId != null : !this$nationalAccountId.equals(other$nationalAccountId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BankAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        String $branchId = this.getBranchId();
        result = result * 59 + ($branchId == null ? 43 : $branchId.hashCode());
        String $accountNr = this.getAccountNr();
        result = result * 59 + ($accountNr == null ? 43 : $accountNr.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        String $holderTaxId = this.getHolderTaxId();
        result = result * 59 + ($holderTaxId == null ? 43 : $holderTaxId.hashCode());
        String $bankId = this.getBankId();
        result = result * 59 + ($bankId == null ? 43 : $bankId.hashCode());
        String $nationalAccountId = this.getNationalAccountId();
        result = result * 59 + ($nationalAccountId == null ? 43 : $nationalAccountId.hashCode());
        return result;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public void setAccountNr(String accountNr) {
        this.accountNr = accountNr;
    }

    public void setAccountType(@Nullable String accountType) {
        this.accountType = accountType;
    }

    public void setHolderTaxId(@Nullable String holderTaxId) {
        this.holderTaxId = holderTaxId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public void setNationalAccountId(@Nullable String nationalAccountId) {
        this.nationalAccountId = nationalAccountId;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public String getAccountNr() {
        return this.accountNr;
    }

    @Nullable
    public String getAccountType() {
        return this.accountType;
    }

    @Nullable
    public String getHolderTaxId() {
        return this.holderTaxId;
    }

    @Nullable
    public String getNationalAccountId() {
        return this.nationalAccountId;
    }

    @Override
    public String toString() {
        return "BankAccountPayload(holderName=" + this.getHolderName() + ", bankName=" + this.getBankName() + ", branchId=" + this.getBranchId() + ", accountNr=" + this.getAccountNr() + ", accountType=" + this.getAccountType() + ", holderTaxId=" + this.getHolderTaxId() + ", bankId=" + this.getBankId() + ", nationalAccountId=" + this.getNationalAccountId() + ")";
    }
}

