/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CashAppAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(CashAppAccountPayload.class);
    private String emailOrMobileNrOrCashtag = "";
    private String extraInfo = "";

    public CashAppAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private CashAppAccountPayload(String paymentMethod, String id, String emailOrMobileNrOrCashtag, String extraInfo, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNrOrCashtag = emailOrMobileNrOrCashtag;
        this.extraInfo = extraInfo;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setCashAppAccountPayload(protobuf.CashAppAccountPayload.newBuilder().setExtraInfo(this.extraInfo).setEmailOrMobileNrOrCashtag(this.emailOrMobileNrOrCashtag)).build();
    }

    public static CashAppAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new CashAppAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getCashAppAccountPayload().getEmailOrMobileNrOrCashtag(), proto.getCashAppAccountPayload().getExtraInfo(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.email.mobile.cashtag") + " " + this.emailOrMobileNrOrCashtag + "\n" + Res.getWithCol("payment.shared.extraInfo") + " " + this.extraInfo + "\n";
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.emailOrMobileNrOrCashtag.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashAppAccountPayload)) {
            return false;
        }
        CashAppAccountPayload other = (CashAppAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNrOrCashtag = this.getEmailOrMobileNrOrCashtag();
        String other$emailOrMobileNrOrCashtag = other.getEmailOrMobileNrOrCashtag();
        if (this$emailOrMobileNrOrCashtag == null ? other$emailOrMobileNrOrCashtag != null : !this$emailOrMobileNrOrCashtag.equals(other$emailOrMobileNrOrCashtag)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CashAppAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNrOrCashtag = this.getEmailOrMobileNrOrCashtag();
        result = result * 59 + ($emailOrMobileNrOrCashtag == null ? 43 : $emailOrMobileNrOrCashtag.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CashAppAccountPayload(emailOrMobileNrOrCashtag=" + this.getEmailOrMobileNrOrCashtag() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public void setEmailOrMobileNrOrCashtag(String emailOrMobileNrOrCashtag) {
        this.emailOrMobileNrOrCashtag = emailOrMobileNrOrCashtag;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getEmailOrMobileNrOrCashtag() {
        return this.emailOrMobileNrOrCashtag;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

