/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CelPayAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(CelPayAccountPayload.class);
    private String email = "";

    public CelPayAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private CelPayAccountPayload(String paymentMethod, String id, String email, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.email = email;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setCelPayAccountPayload(protobuf.CelPayAccountPayload.newBuilder().setEmail(this.email)).build();
    }

    public static CelPayAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new CelPayAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getCelPayAccountPayload().getEmail(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.email") + " " + this.email;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.email.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CelPayAccountPayload)) {
            return false;
        }
        CelPayAccountPayload other = (CelPayAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CelPayAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CelPayAccountPayload(email=" + this.getEmail() + ")";
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }
}

