/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.F2FAccountPayload;

public final class F2FAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(F2FAccountPayload.class);
    private String contact = "";
    private String city = "";
    private String extraInfo = "";

    public F2FAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private F2FAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String contact, String city, String extraInfo, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.contact = contact;
        this.city = city;
        this.extraInfo = extraInfo;
    }

    @Override
    public Message toProtoMessage() {
        F2FAccountPayload.Builder builder = protobuf.F2FAccountPayload.newBuilder().setContact(this.contact).setCity(this.city).setExtraInfo(this.extraInfo);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setF2FAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.F2FAccountPayload f2fAccountPayloadPB = countryBasedPaymentAccountPayload.getF2FAccountPayload();
        return new F2FAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>(countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), f2fAccountPayloadPB.getContact(), f2fAccountPayloadPB.getCity(), f2fAccountPayloadPB.getExtraInfo(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.f2f.contact") + " " + this.contact + ", " + Res.getWithCol("payment.f2f.city") + " " + this.city + ", " + Res.getWithCol("payment.shared.extraInfo") + " " + this.extraInfo;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.f2f.contact") + " " + this.contact;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll(this.contact.getBytes(StandardCharsets.UTF_8), this.city.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof F2FAccountPayload)) {
            return false;
        }
        F2FAccountPayload other = (F2FAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$contact = this.getContact();
        String other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof F2FAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "F2FAccountPayload(contact=" + this.getContact() + ", city=" + this.getCity() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getContact() {
        return this.contact;
    }

    public String getCity() {
        return this.city;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

