/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HalCashAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(HalCashAccountPayload.class);
    private String mobileNr = "";

    public HalCashAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private HalCashAccountPayload(String paymentMethod, String id, String mobileNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.mobileNr = mobileNr;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setHalCashAccountPayload(protobuf.HalCashAccountPayload.newBuilder().setMobileNr(this.mobileNr)).build();
    }

    public static HalCashAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new HalCashAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getHalCashAccountPayload().getMobileNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.mobile") + " " + this.mobileNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.mobile") + " " + this.mobileNr;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.mobileNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HalCashAccountPayload)) {
            return false;
        }
        HalCashAccountPayload other = (HalCashAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mobileNr = this.getMobileNr();
        String other$mobileNr = other.getMobileNr();
        return !(this$mobileNr == null ? other$mobileNr != null : !this$mobileNr.equals(other$mobileNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HalCashAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mobileNr = this.getMobileNr();
        result = result * 59 + ($mobileNr == null ? 43 : $mobileNr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HalCashAccountPayload(mobileNr=" + this.getMobileNr() + ")";
    }

    public void setMobileNr(String mobileNr) {
        this.mobileNr = mobileNr;
    }

    public String getMobileNr() {
        return this.mobileNr;
    }
}

