/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.payment.payload.AssetAccountPayload;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.InstantCryptoCurrencyAccountPayload;
import protobuf.PaymentAccountPayload;

public final class InstantCryptoCurrencyPayload
extends AssetAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(InstantCryptoCurrencyPayload.class);

    public InstantCryptoCurrencyPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private InstantCryptoCurrencyPayload(String paymentMethod, String id, String address, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, address, maxTradePeriod, excludeFromJsonDataMap);
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setInstantCryptoCurrencyAccountPayload(InstantCryptoCurrencyAccountPayload.newBuilder().setAddress(this.address)).build();
    }

    public static InstantCryptoCurrencyPayload fromProto(PaymentAccountPayload proto) {
        return new InstantCryptoCurrencyPayload(proto.getPaymentMethodId(), proto.getId(), proto.getInstantCryptoCurrencyAccountPayload().getAddress(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstantCryptoCurrencyPayload)) {
            return false;
        }
        InstantCryptoCurrencyPayload other = (InstantCryptoCurrencyPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InstantCryptoCurrencyPayload;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "InstantCryptoCurrencyPayload()";
    }
}

