/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InteracETransferAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(InteracETransferAccountPayload.class);
    private String email = "";
    private String holderName = "";
    private String question = "";
    private String answer = "";

    public InteracETransferAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private InteracETransferAccountPayload(String paymentMethod, String id, String email, String holderName, String question, String answer, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.email = email;
        this.holderName = holderName;
        this.question = question;
        this.answer = answer;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setInteracETransferAccountPayload(protobuf.InteracETransferAccountPayload.newBuilder().setEmail(this.email).setHolderName(this.holderName).setQuestion(this.question).setAnswer(this.answer)).build();
    }

    public static InteracETransferAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new InteracETransferAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getInteracETransferAccountPayload().getEmail(), proto.getInteracETransferAccountPayload().getHolderName(), proto.getInteracETransferAccountPayload().getQuestion(), proto.getInteracETransferAccountPayload().getAnswer(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.get("payment.email") + " " + this.email + ", " + Res.getWithCol("payment.secret") + " " + this.question + ", " + Res.getWithCol("payment.answer") + " " + this.answer;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + Res.getWithCol("payment.email") + " " + this.email + "\n" + Res.getWithCol("payment.secret") + " " + this.question + "\n" + Res.getWithCol("payment.answer") + " " + this.answer;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll(this.email.getBytes(StandardCharsets.UTF_8), ArrayUtils.addAll(this.question.getBytes(StandardCharsets.UTF_8), this.answer.getBytes(StandardCharsets.UTF_8))));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteracETransferAccountPayload)) {
            return false;
        }
        InteracETransferAccountPayload other = (InteracETransferAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        String this$answer = this.getAnswer();
        String other$answer = other.getAnswer();
        return !(this$answer == null ? other$answer != null : !this$answer.equals(other$answer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InteracETransferAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        String $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "InteracETransferAccountPayload(email=" + this.getEmail() + ", holderName=" + this.getHolderName() + ", question=" + this.getQuestion() + ", answer=" + this.getAnswer() + ")";
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getAnswer() {
        return this.answer;
    }
}

