/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.BankUtil;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.MoneyGramAccountPayload;

public class MoneyGramAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(MoneyGramAccountPayload.class);
    private String holderName;
    private String countryCode = "";
    private String state = "";
    private String email;

    public MoneyGramAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private MoneyGramAccountPayload(String paymentMethodName, String id, String countryCode, String holderName, String state, String email, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.countryCode = countryCode;
        this.state = state;
        this.email = email;
    }

    @Override
    public Message toProtoMessage() {
        MoneyGramAccountPayload.Builder builder = protobuf.MoneyGramAccountPayload.newBuilder().setHolderName(this.holderName).setCountryCode(this.countryCode).setState(this.state).setEmail(this.email);
        return this.getPaymentAccountPayloadBuilder().setMoneyGramAccountPayload(builder).build();
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.MoneyGramAccountPayload moneyGramAccountPayload = proto.getMoneyGramAccountPayload();
        return new MoneyGramAccountPayload(proto.getPaymentMethodId(), proto.getId(), moneyGramAccountPayload.getCountryCode(), moneyGramAccountPayload.getHolderName(), moneyGramAccountPayload.getState(), moneyGramAccountPayload.getEmail(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        String state = BankUtil.isStateRequired(this.countryCode) ? Res.getWithCol("payment.account.state") + " " + this.state + "\n" : "";
        return Res.getWithCol("payment.account.fullName") + " " + this.holderName + "\n" + state + Res.getWithCol("payment.bank.country") + " " + CountryUtil.getNameByCode(this.countryCode) + "\n" + Res.getWithCol("payment.email") + " " + this.email;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String all = this.countryCode + this.state + this.holderName + this.email;
        return super.getAgeWitnessInputData(all.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoneyGramAccountPayload)) {
            return false;
        }
        MoneyGramAccountPayload other = (MoneyGramAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MoneyGramAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MoneyGramAccountPayload(holderName=" + this.getHolderName() + ", countryCode=" + this.getCountryCode() + ", state=" + this.getState() + ", email=" + this.getEmail() + ")";
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getState() {
        return this.state;
    }

    public String getEmail() {
        return this.email;
    }
}

