/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PayByMailAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(PayByMailAccountPayload.class);
    private String postalAddress = "";
    private String contact = "";
    private String extraInfo = "";

    public PayByMailAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private PayByMailAccountPayload(String paymentMethod, String id, String postalAddress, String contact, String extraInfo, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.postalAddress = postalAddress;
        this.contact = contact;
        this.extraInfo = extraInfo;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setPayByMailAccountPayload(protobuf.PayByMailAccountPayload.newBuilder().setPostalAddress(this.postalAddress).setContact(this.contact).setExtraInfo(this.extraInfo)).build();
    }

    public static PayByMailAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new PayByMailAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getPayByMailAccountPayload().getPostalAddress(), proto.getPayByMailAccountPayload().getContact(), proto.getPayByMailAccountPayload().getExtraInfo(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.contact + ", " + Res.getWithCol("payment.postal.address") + " " + this.postalAddress + ", " + Res.getWithCol("payment.shared.extraInfo") + " " + this.extraInfo;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.contact + "\n" + Res.getWithCol("payment.postal.address") + " " + this.postalAddress;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll(this.contact.getBytes(StandardCharsets.UTF_8), this.postalAddress.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String getOwnerId() {
        return this.contact;
    }

    @Override
    public String getHolderName() {
        return this.contact;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayByMailAccountPayload)) {
            return false;
        }
        PayByMailAccountPayload other = (PayByMailAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$postalAddress = this.getPostalAddress();
        String other$postalAddress = other.getPostalAddress();
        if (this$postalAddress == null ? other$postalAddress != null : !this$postalAddress.equals(other$postalAddress)) {
            return false;
        }
        String this$contact = this.getContact();
        String other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayByMailAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $postalAddress = this.getPostalAddress();
        result = result * 59 + ($postalAddress == null ? 43 : $postalAddress.hashCode());
        String $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PayByMailAccountPayload(postalAddress=" + this.getPostalAddress() + ", contact=" + this.getContact() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getPostalAddress() {
        return this.postalAddress;
    }

    public String getContact() {
        return this.contact;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

