/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PayPalAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(PayPalAccountPayload.class);
    private String emailOrMobileNrOrUsername = "";
    private String extraInfo = "";

    public PayPalAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private PayPalAccountPayload(String paymentMethod, String id, String emailOrMobileNrOrUsername, String extraInfo, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNrOrUsername = emailOrMobileNrOrUsername;
        this.extraInfo = extraInfo;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setPaypalAccountPayload(protobuf.PayPalAccountPayload.newBuilder().setExtraInfo(this.extraInfo).setEmailOrMobileNrOrUsername(this.emailOrMobileNrOrUsername)).build();
    }

    public static PayPalAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new PayPalAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getPaypalAccountPayload().getEmailOrMobileNrOrUsername(), proto.getPaypalAccountPayload().getExtraInfo(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.getWithCol("payment.email.mobile.username") + " " + this.emailOrMobileNrOrUsername + "\n" + Res.getWithCol("payment.shared.extraInfo") + " " + this.extraInfo + "\n";
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.emailOrMobileNrOrUsername.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayPalAccountPayload)) {
            return false;
        }
        PayPalAccountPayload other = (PayPalAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNrOrUsername = this.getEmailOrMobileNrOrUsername();
        String other$emailOrMobileNrOrUsername = other.getEmailOrMobileNrOrUsername();
        if (this$emailOrMobileNrOrUsername == null ? other$emailOrMobileNrOrUsername != null : !this$emailOrMobileNrOrUsername.equals(other$emailOrMobileNrOrUsername)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayPalAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNrOrUsername = this.getEmailOrMobileNrOrUsername();
        result = result * 59 + ($emailOrMobileNrOrUsername == null ? 43 : $emailOrMobileNrOrUsername.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PayPalAccountPayload(emailOrMobileNrOrUsername=" + this.getEmailOrMobileNrOrUsername() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public void setEmailOrMobileNrOrUsername(String emailOrMobileNrOrUsername) {
        this.emailOrMobileNrOrUsername = emailOrMobileNrOrUsername;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getEmailOrMobileNrOrUsername() {
        return this.emailOrMobileNrOrUsername;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

