/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.PixAccountPayload;

public final class PixAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(PixAccountPayload.class);
    private String pixKey = "";

    public PixAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private PixAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String pixKey, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.pixKey = pixKey;
    }

    @Override
    public Message toProtoMessage() {
        PixAccountPayload.Builder builder = protobuf.PixAccountPayload.newBuilder().setPixKey(this.pixKey);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setPixAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static PixAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.PixAccountPayload paytmAccountPayloadPB = countryBasedPaymentAccountPayload.getPixAccountPayload();
        return new PixAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>(countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), paytmAccountPayloadPB.getPixKey(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.pix.key") + " " + this.pixKey;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.pixKey.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PixAccountPayload)) {
            return false;
        }
        PixAccountPayload other = (PixAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pixKey = this.getPixKey();
        String other$pixKey = other.getPixKey();
        return !(this$pixKey == null ? other$pixKey != null : !this$pixKey.equals(other$pixKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PixAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pixKey = this.getPixKey();
        result = result * 59 + ($pixKey == null ? 43 : $pixKey.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PixAccountPayload(pixKey=" + this.getPixKey() + ")";
    }

    public void setPixKey(String pixKey) {
        this.pixKey = pixKey;
    }

    public String getPixKey() {
        return this.pixKey;
    }
}

