/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.IfscBasedAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.IfscBasedAccountPayload;
import protobuf.PaymentAccountPayload;

public final class RtgsAccountPayload
extends IfscBasedAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(RtgsAccountPayload.class);

    public RtgsAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private RtgsAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String accountNr, String ifsc, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, holderName, accountNr, ifsc, maxTradePeriod, excludeFromJsonDataMap);
    }

    @Override
    public Message toProtoMessage() {
        IfscBasedAccountPayload.Builder ifscBasedAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().getIfscBasedAccountPayloadBuilder().setRtgsAccountPayload(protobuf.RtgsAccountPayload.newBuilder());
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setIfscBasedAccountPayload(ifscBasedAccountPayloadBuilder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder).build();
    }

    public static RtgsAccountPayload fromProto(PaymentAccountPayload proto) {
        CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.IfscBasedAccountPayload ifscBasedAccountPayloadPB = countryBasedPaymentAccountPayload.getIfscBasedAccountPayload();
        return new RtgsAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>(countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), ifscBasedAccountPayloadPB.getHolderName(), ifscBasedAccountPayloadPB.getAccountNr(), ifscBasedAccountPayloadPB.getIfsc(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.getWithCol("payment.account.no") + " " + this.accountNr + Res.getWithCol("payment.ifsc") + " " + this.ifsc;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String accountNr = this.accountNr == null ? "" : this.accountNr;
        return super.getAgeWitnessInputData(accountNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getHolderName() {
        return this.getOwnerId();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtgsAccountPayload)) {
            return false;
        }
        RtgsAccountPayload other = (RtgsAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RtgsAccountPayload;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "RtgsAccountPayload()";
    }
}

