/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.SatispayAccountPayload;

public final class SatispayAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(SatispayAccountPayload.class);
    private String holderName = "";
    private String mobileNr = "";

    public SatispayAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private SatispayAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String mobileNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.mobileNr = mobileNr;
    }

    @Override
    public Message toProtoMessage() {
        SatispayAccountPayload.Builder builder = protobuf.SatispayAccountPayload.newBuilder().setHolderName(this.holderName).setMobileNr(this.mobileNr);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setSatispayAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static SatispayAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.SatispayAccountPayload accountPayloadPB = countryBasedPaymentAccountPayload.getSatispayAccountPayload();
        return new SatispayAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>(countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), accountPayloadPB.getHolderName(), accountPayloadPB.getMobileNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.username") + " " + this.holderName;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.holderName.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SatispayAccountPayload)) {
            return false;
        }
        SatispayAccountPayload other = (SatispayAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$mobileNr = this.getMobileNr();
        String other$mobileNr = other.getMobileNr();
        return !(this$mobileNr == null ? other$mobileNr != null : !this$mobileNr.equals(other$mobileNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SatispayAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $mobileNr = this.getMobileNr();
        result = result * 59 + ($mobileNr == null ? 43 : $mobileNr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SatispayAccountPayload(holderName=" + this.getHolderName() + ", mobileNr=" + this.getMobileNr() + ")";
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setMobileNr(String mobileNr) {
        this.mobileNr = mobileNr;
    }

    public String getHolderName() {
        return this.holderName;
    }

    public String getMobileNr() {
        return this.mobileNr;
    }
}

