/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.SepaInstantAccountPayload;

public final class SepaInstantAccountPayload
extends CountryBasedPaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(SepaInstantAccountPayload.class);
    private String holderName = "";
    private String iban = "";
    private String bic = "";
    private final List<String> persistedAcceptedCountryCodes = new ArrayList<String>();

    public SepaInstantAccountPayload(String paymentMethod, String id, List<Country> acceptedCountries) {
        super(paymentMethod, id);
        this.acceptedCountryCodes = acceptedCountries.stream().map(e -> e.code).sorted().distinct().collect(Collectors.toList());
    }

    private SepaInstantAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String iban, String bic, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.iban = iban;
        this.bic = bic;
        this.persistedAcceptedCountryCodes.addAll(acceptedCountryCodes);
    }

    @Override
    public Message toProtoMessage() {
        SepaInstantAccountPayload.Builder builder = protobuf.SepaInstantAccountPayload.newBuilder().setHolderName(this.holderName).setIban(this.iban).setBic(this.bic);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setSepaInstantAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.SepaInstantAccountPayload sepaInstantAccountPayloadPB = countryBasedPaymentAccountPayload.getSepaInstantAccountPayload();
        return new SepaInstantAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>(countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), sepaInstantAccountPayloadPB.getHolderName(), sepaInstantAccountPayloadPB.getIban(), sepaInstantAccountPayloadPB.getBic(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    public void addAcceptedCountry(String countryCode) {
        if (!this.acceptedCountryCodes.contains(countryCode)) {
            this.acceptedCountryCodes.add(countryCode);
        }
    }

    public void removeAcceptedCountry(String countryCode) {
        this.acceptedCountryCodes.remove(countryCode);
    }

    public void onPersistChanges() {
        this.persistedAcceptedCountryCodes.clear();
        this.persistedAcceptedCountryCodes.addAll(this.acceptedCountryCodes);
    }

    public void revertChanges() {
        this.acceptedCountryCodes.clear();
        this.acceptedCountryCodes.addAll(this.persistedAcceptedCountryCodes);
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", IBAN: " + this.iban + ", BIC: " + this.bic + ", " + Res.getWithCol("payment.bank.country") + " " + this.getCountryCode();
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\nIBAN: " + this.iban + "\nBIC: " + this.bic + "\n" + Res.getWithCol("payment.bank.country") + " " + CountryUtil.getNameByCode(this.countryCode);
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll(this.iban.getBytes(StandardCharsets.UTF_8), this.bic.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SepaInstantAccountPayload)) {
            return false;
        }
        SepaInstantAccountPayload other = (SepaInstantAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        List<String> this$persistedAcceptedCountryCodes = this.getPersistedAcceptedCountryCodes();
        List<String> other$persistedAcceptedCountryCodes = other.getPersistedAcceptedCountryCodes();
        return !(this$persistedAcceptedCountryCodes == null ? other$persistedAcceptedCountryCodes != null : !((Object)this$persistedAcceptedCountryCodes).equals(other$persistedAcceptedCountryCodes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SepaInstantAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        List<String> $persistedAcceptedCountryCodes = this.getPersistedAcceptedCountryCodes();
        result = result * 59 + ($persistedAcceptedCountryCodes == null ? 43 : ((Object)$persistedAcceptedCountryCodes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SepaInstantAccountPayload(holderName=" + this.getHolderName() + ", iban=" + this.getIban() + ", bic=" + this.getBic() + ", persistedAcceptedCountryCodes=" + String.valueOf(this.getPersistedAcceptedCountryCodes()) + ")";
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getIban() {
        return this.iban;
    }

    public String getBic() {
        return this.bic;
    }

    public List<String> getPersistedAcceptedCountryCodes() {
        return this.persistedAcceptedCountryCodes;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }
}

