/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwiftAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(SwiftAccountPayload.class);
    private String bankSwiftCode = "";
    private String bankCountryCode = "";
    private String bankName = "";
    private String bankBranch = "";
    private String bankAddress = "";
    private String beneficiaryName = "";
    private String beneficiaryAccountNr = "";
    private String beneficiaryAddress = "";
    private String beneficiaryCity = "";
    private String beneficiaryPhone = "";
    private String specialInstructions = "";
    private String intermediarySwiftCode = "";
    private String intermediaryCountryCode = "";
    private String intermediaryName = "";
    private String intermediaryBranch = "";
    private String intermediaryAddress = "";
    public static final String BANKPOSTFIX = ".bank";
    public static final String INTERMEDIARYPOSTFIX = ".intermediary";
    public static final String BENEFICIARYPOSTFIX = ".beneficiary";
    public static final String SWIFT_CODE = "payment.swift.swiftCode";
    public static final String COUNTRY = "payment.swift.country";
    public static final String SWIFT_ACCOUNT = "payment.swift.account";
    public static final String SNAME = "payment.swift.name";
    public static final String BRANCH = "payment.swift.branch";
    public static final String ADDRESS = "payment.swift.address";
    public static final String PHONE = "payment.swift.phone";

    public SwiftAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private SwiftAccountPayload(String paymentMethod, String id, String bankSwiftCode, String bankCountryCode, String bankName, String bankBranch, String bankAddress, String beneficiaryName, String beneficiaryAccountNr, String beneficiaryAddress, String beneficiaryCity, String beneficiaryPhone, String specialInstructions, String intermediarySwiftCode, String intermediaryCountryCode, String intermediaryName, String intermediaryBranch, String intermediaryAddress, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.bankSwiftCode = bankSwiftCode;
        this.bankCountryCode = bankCountryCode;
        this.bankName = bankName;
        this.bankBranch = bankBranch;
        this.bankAddress = bankAddress;
        this.beneficiaryName = beneficiaryName;
        this.beneficiaryAccountNr = beneficiaryAccountNr;
        this.beneficiaryAddress = beneficiaryAddress;
        this.beneficiaryCity = beneficiaryCity;
        this.beneficiaryPhone = beneficiaryPhone;
        this.specialInstructions = specialInstructions;
        this.intermediarySwiftCode = intermediarySwiftCode;
        this.intermediaryCountryCode = intermediaryCountryCode;
        this.intermediaryName = intermediaryName;
        this.intermediaryBranch = intermediaryBranch;
        this.intermediaryAddress = intermediaryAddress;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setSwiftAccountPayload(protobuf.SwiftAccountPayload.newBuilder().setBankSwiftCode(this.bankSwiftCode).setBankCountryCode(this.bankCountryCode).setBankName(this.bankName).setBankBranch(this.bankBranch).setBankAddress(this.bankAddress).setBeneficiaryName(this.beneficiaryName).setBeneficiaryAccountNr(this.beneficiaryAccountNr).setBeneficiaryAddress(this.beneficiaryAddress).setBeneficiaryCity(this.beneficiaryCity).setBeneficiaryPhone(this.beneficiaryPhone).setSpecialInstructions(this.specialInstructions).setIntermediarySwiftCode(this.intermediarySwiftCode).setIntermediaryCountryCode(this.intermediaryCountryCode).setIntermediaryName(this.intermediaryName).setIntermediaryBranch(this.intermediaryBranch).setIntermediaryAddress(this.intermediaryAddress)).build();
    }

    public static SwiftAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.SwiftAccountPayload x = proto.getSwiftAccountPayload();
        return new SwiftAccountPayload(proto.getPaymentMethodId(), proto.getId(), x.getBankSwiftCode(), x.getBankCountryCode(), x.getBankName(), x.getBankBranch(), x.getBankAddress(), x.getBeneficiaryName(), x.getBeneficiaryAccountNr(), x.getBeneficiaryAddress(), x.getBeneficiaryCity(), x.getBeneficiaryPhone(), x.getSpecialInstructions(), x.getIntermediarySwiftCode(), x.getIntermediaryCountryCode(), x.getIntermediaryName(), x.getIntermediaryBranch(), x.getIntermediaryAddress(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.beneficiaryName;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.beneficiaryAccountNr.getBytes(StandardCharsets.UTF_8));
    }

    public boolean usesIntermediaryBank() {
        return this.intermediarySwiftCode != null && this.intermediarySwiftCode.length() > 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwiftAccountPayload)) {
            return false;
        }
        SwiftAccountPayload other = (SwiftAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bankSwiftCode = this.getBankSwiftCode();
        String other$bankSwiftCode = other.getBankSwiftCode();
        if (this$bankSwiftCode == null ? other$bankSwiftCode != null : !this$bankSwiftCode.equals(other$bankSwiftCode)) {
            return false;
        }
        String this$bankCountryCode = this.getBankCountryCode();
        String other$bankCountryCode = other.getBankCountryCode();
        if (this$bankCountryCode == null ? other$bankCountryCode != null : !this$bankCountryCode.equals(other$bankCountryCode)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        String this$bankBranch = this.getBankBranch();
        String other$bankBranch = other.getBankBranch();
        if (this$bankBranch == null ? other$bankBranch != null : !this$bankBranch.equals(other$bankBranch)) {
            return false;
        }
        String this$bankAddress = this.getBankAddress();
        String other$bankAddress = other.getBankAddress();
        if (this$bankAddress == null ? other$bankAddress != null : !this$bankAddress.equals(other$bankAddress)) {
            return false;
        }
        String this$beneficiaryName = this.getBeneficiaryName();
        String other$beneficiaryName = other.getBeneficiaryName();
        if (this$beneficiaryName == null ? other$beneficiaryName != null : !this$beneficiaryName.equals(other$beneficiaryName)) {
            return false;
        }
        String this$beneficiaryAccountNr = this.getBeneficiaryAccountNr();
        String other$beneficiaryAccountNr = other.getBeneficiaryAccountNr();
        if (this$beneficiaryAccountNr == null ? other$beneficiaryAccountNr != null : !this$beneficiaryAccountNr.equals(other$beneficiaryAccountNr)) {
            return false;
        }
        String this$beneficiaryAddress = this.getBeneficiaryAddress();
        String other$beneficiaryAddress = other.getBeneficiaryAddress();
        if (this$beneficiaryAddress == null ? other$beneficiaryAddress != null : !this$beneficiaryAddress.equals(other$beneficiaryAddress)) {
            return false;
        }
        String this$beneficiaryCity = this.getBeneficiaryCity();
        String other$beneficiaryCity = other.getBeneficiaryCity();
        if (this$beneficiaryCity == null ? other$beneficiaryCity != null : !this$beneficiaryCity.equals(other$beneficiaryCity)) {
            return false;
        }
        String this$beneficiaryPhone = this.getBeneficiaryPhone();
        String other$beneficiaryPhone = other.getBeneficiaryPhone();
        if (this$beneficiaryPhone == null ? other$beneficiaryPhone != null : !this$beneficiaryPhone.equals(other$beneficiaryPhone)) {
            return false;
        }
        String this$specialInstructions = this.getSpecialInstructions();
        String other$specialInstructions = other.getSpecialInstructions();
        if (this$specialInstructions == null ? other$specialInstructions != null : !this$specialInstructions.equals(other$specialInstructions)) {
            return false;
        }
        String this$intermediarySwiftCode = this.getIntermediarySwiftCode();
        String other$intermediarySwiftCode = other.getIntermediarySwiftCode();
        if (this$intermediarySwiftCode == null ? other$intermediarySwiftCode != null : !this$intermediarySwiftCode.equals(other$intermediarySwiftCode)) {
            return false;
        }
        String this$intermediaryCountryCode = this.getIntermediaryCountryCode();
        String other$intermediaryCountryCode = other.getIntermediaryCountryCode();
        if (this$intermediaryCountryCode == null ? other$intermediaryCountryCode != null : !this$intermediaryCountryCode.equals(other$intermediaryCountryCode)) {
            return false;
        }
        String this$intermediaryName = this.getIntermediaryName();
        String other$intermediaryName = other.getIntermediaryName();
        if (this$intermediaryName == null ? other$intermediaryName != null : !this$intermediaryName.equals(other$intermediaryName)) {
            return false;
        }
        String this$intermediaryBranch = this.getIntermediaryBranch();
        String other$intermediaryBranch = other.getIntermediaryBranch();
        if (this$intermediaryBranch == null ? other$intermediaryBranch != null : !this$intermediaryBranch.equals(other$intermediaryBranch)) {
            return false;
        }
        String this$intermediaryAddress = this.getIntermediaryAddress();
        String other$intermediaryAddress = other.getIntermediaryAddress();
        return !(this$intermediaryAddress == null ? other$intermediaryAddress != null : !this$intermediaryAddress.equals(other$intermediaryAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SwiftAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bankSwiftCode = this.getBankSwiftCode();
        result = result * 59 + ($bankSwiftCode == null ? 43 : $bankSwiftCode.hashCode());
        String $bankCountryCode = this.getBankCountryCode();
        result = result * 59 + ($bankCountryCode == null ? 43 : $bankCountryCode.hashCode());
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        String $bankBranch = this.getBankBranch();
        result = result * 59 + ($bankBranch == null ? 43 : $bankBranch.hashCode());
        String $bankAddress = this.getBankAddress();
        result = result * 59 + ($bankAddress == null ? 43 : $bankAddress.hashCode());
        String $beneficiaryName = this.getBeneficiaryName();
        result = result * 59 + ($beneficiaryName == null ? 43 : $beneficiaryName.hashCode());
        String $beneficiaryAccountNr = this.getBeneficiaryAccountNr();
        result = result * 59 + ($beneficiaryAccountNr == null ? 43 : $beneficiaryAccountNr.hashCode());
        String $beneficiaryAddress = this.getBeneficiaryAddress();
        result = result * 59 + ($beneficiaryAddress == null ? 43 : $beneficiaryAddress.hashCode());
        String $beneficiaryCity = this.getBeneficiaryCity();
        result = result * 59 + ($beneficiaryCity == null ? 43 : $beneficiaryCity.hashCode());
        String $beneficiaryPhone = this.getBeneficiaryPhone();
        result = result * 59 + ($beneficiaryPhone == null ? 43 : $beneficiaryPhone.hashCode());
        String $specialInstructions = this.getSpecialInstructions();
        result = result * 59 + ($specialInstructions == null ? 43 : $specialInstructions.hashCode());
        String $intermediarySwiftCode = this.getIntermediarySwiftCode();
        result = result * 59 + ($intermediarySwiftCode == null ? 43 : $intermediarySwiftCode.hashCode());
        String $intermediaryCountryCode = this.getIntermediaryCountryCode();
        result = result * 59 + ($intermediaryCountryCode == null ? 43 : $intermediaryCountryCode.hashCode());
        String $intermediaryName = this.getIntermediaryName();
        result = result * 59 + ($intermediaryName == null ? 43 : $intermediaryName.hashCode());
        String $intermediaryBranch = this.getIntermediaryBranch();
        result = result * 59 + ($intermediaryBranch == null ? 43 : $intermediaryBranch.hashCode());
        String $intermediaryAddress = this.getIntermediaryAddress();
        result = result * 59 + ($intermediaryAddress == null ? 43 : $intermediaryAddress.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SwiftAccountPayload(bankSwiftCode=" + this.getBankSwiftCode() + ", bankCountryCode=" + this.getBankCountryCode() + ", bankName=" + this.getBankName() + ", bankBranch=" + this.getBankBranch() + ", bankAddress=" + this.getBankAddress() + ", beneficiaryName=" + this.getBeneficiaryName() + ", beneficiaryAccountNr=" + this.getBeneficiaryAccountNr() + ", beneficiaryAddress=" + this.getBeneficiaryAddress() + ", beneficiaryCity=" + this.getBeneficiaryCity() + ", beneficiaryPhone=" + this.getBeneficiaryPhone() + ", specialInstructions=" + this.getSpecialInstructions() + ", intermediarySwiftCode=" + this.getIntermediarySwiftCode() + ", intermediaryCountryCode=" + this.getIntermediaryCountryCode() + ", intermediaryName=" + this.getIntermediaryName() + ", intermediaryBranch=" + this.getIntermediaryBranch() + ", intermediaryAddress=" + this.getIntermediaryAddress() + ")";
    }

    public void setBankSwiftCode(String bankSwiftCode) {
        this.bankSwiftCode = bankSwiftCode;
    }

    public void setBankCountryCode(String bankCountryCode) {
        this.bankCountryCode = bankCountryCode;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
    }

    public void setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress;
    }

    public void setBeneficiaryName(String beneficiaryName) {
        this.beneficiaryName = beneficiaryName;
    }

    public void setBeneficiaryAccountNr(String beneficiaryAccountNr) {
        this.beneficiaryAccountNr = beneficiaryAccountNr;
    }

    public void setBeneficiaryAddress(String beneficiaryAddress) {
        this.beneficiaryAddress = beneficiaryAddress;
    }

    public void setBeneficiaryCity(String beneficiaryCity) {
        this.beneficiaryCity = beneficiaryCity;
    }

    public void setBeneficiaryPhone(String beneficiaryPhone) {
        this.beneficiaryPhone = beneficiaryPhone;
    }

    public void setSpecialInstructions(String specialInstructions) {
        this.specialInstructions = specialInstructions;
    }

    public void setIntermediarySwiftCode(String intermediarySwiftCode) {
        this.intermediarySwiftCode = intermediarySwiftCode;
    }

    public void setIntermediaryCountryCode(String intermediaryCountryCode) {
        this.intermediaryCountryCode = intermediaryCountryCode;
    }

    public void setIntermediaryName(String intermediaryName) {
        this.intermediaryName = intermediaryName;
    }

    public void setIntermediaryBranch(String intermediaryBranch) {
        this.intermediaryBranch = intermediaryBranch;
    }

    public void setIntermediaryAddress(String intermediaryAddress) {
        this.intermediaryAddress = intermediaryAddress;
    }

    public String getBankSwiftCode() {
        return this.bankSwiftCode;
    }

    public String getBankCountryCode() {
        return this.bankCountryCode;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBankBranch() {
        return this.bankBranch;
    }

    public String getBankAddress() {
        return this.bankAddress;
    }

    public String getBeneficiaryName() {
        return this.beneficiaryName;
    }

    public String getBeneficiaryAccountNr() {
        return this.beneficiaryAccountNr;
    }

    public String getBeneficiaryAddress() {
        return this.beneficiaryAddress;
    }

    public String getBeneficiaryCity() {
        return this.beneficiaryCity;
    }

    public String getBeneficiaryPhone() {
        return this.beneficiaryPhone;
    }

    public String getSpecialInstructions() {
        return this.specialInstructions;
    }

    public String getIntermediarySwiftCode() {
        return this.intermediarySwiftCode;
    }

    public String getIntermediaryCountryCode() {
        return this.intermediaryCountryCode;
    }

    public String getIntermediaryName() {
        return this.intermediaryName;
    }

    public String getIntermediaryBranch() {
        return this.intermediaryBranch;
    }

    public String getIntermediaryAddress() {
        return this.intermediaryAddress;
    }
}

