/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class USPostalMoneyOrderAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(USPostalMoneyOrderAccountPayload.class);
    private String postalAddress = "";
    private String holderName = "";

    public USPostalMoneyOrderAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private USPostalMoneyOrderAccountPayload(String paymentMethod, String id, String postalAddress, String holderName, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.postalAddress = postalAddress;
        this.holderName = holderName;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setUSPostalMoneyOrderAccountPayload(protobuf.USPostalMoneyOrderAccountPayload.newBuilder().setPostalAddress(this.postalAddress).setHolderName(this.holderName)).build();
    }

    public static USPostalMoneyOrderAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new USPostalMoneyOrderAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getUSPostalMoneyOrderAccountPayload().getPostalAddress(), proto.getUSPostalMoneyOrderAccountPayload().getHolderName(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.getWithCol("payment.postal.address") + " " + this.postalAddress;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + Res.getWithCol("payment.postal.address") + " " + this.postalAddress;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll(this.holderName.getBytes(StandardCharsets.UTF_8), this.postalAddress.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof USPostalMoneyOrderAccountPayload)) {
            return false;
        }
        USPostalMoneyOrderAccountPayload other = (USPostalMoneyOrderAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$postalAddress = this.getPostalAddress();
        String other$postalAddress = other.getPostalAddress();
        if (this$postalAddress == null ? other$postalAddress != null : !this$postalAddress.equals(other$postalAddress)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        return !(this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof USPostalMoneyOrderAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $postalAddress = this.getPostalAddress();
        result = result * 59 + ($postalAddress == null ? 43 : $postalAddress.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "USPostalMoneyOrderAccountPayload(postalAddress=" + this.getPostalAddress() + ", holderName=" + this.getHolderName() + ")";
    }

    public void setPostalAddress(String postalAddress) {
        this.postalAddress = postalAddress;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getPostalAddress() {
        return this.postalAddress;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }
}

