/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpholdAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(UpholdAccountPayload.class);
    private String accountId = "";
    private String accountOwner = "";

    public UpholdAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private UpholdAccountPayload(String paymentMethod, String id, String accountId, String accountOwner, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.accountId = accountId;
        this.accountOwner = accountOwner;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setUpholdAccountPayload(protobuf.UpholdAccountPayload.newBuilder().setAccountOwner(this.accountOwner).setAccountId(this.accountId)).build();
    }

    public static UpholdAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new UpholdAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getUpholdAccountPayload().getAccountId(), proto.getUpholdAccountPayload().getAccountOwner(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        if (this.accountOwner.isEmpty()) {
            return Res.get("payment.account") + ": " + this.accountId + "\n" + Res.get("payment.account.owner") + ": N/A";
        }
        return Res.get("payment.account") + ": " + this.accountId + "\n" + Res.get("payment.account.owner") + ": " + this.accountOwner;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.accountId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpholdAccountPayload)) {
            return false;
        }
        UpholdAccountPayload other = (UpholdAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$accountOwner = this.getAccountOwner();
        String other$accountOwner = other.getAccountOwner();
        return !(this$accountOwner == null ? other$accountOwner != null : !this$accountOwner.equals(other$accountOwner));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpholdAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $accountOwner = this.getAccountOwner();
        result = result * 59 + ($accountOwner == null ? 43 : $accountOwner.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UpholdAccountPayload(accountId=" + this.getAccountId() + ", accountOwner=" + this.getAccountOwner() + ")";
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setAccountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountOwner() {
        return this.accountOwner;
    }
}

