/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.UpiAccountPayload;

public final class UpiAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(UpiAccountPayload.class);
    private String virtualPaymentAddress = "";

    public UpiAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private UpiAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String virtualPaymentAddress, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.virtualPaymentAddress = virtualPaymentAddress;
    }

    @Override
    public Message toProtoMessage() {
        UpiAccountPayload.Builder builder = protobuf.UpiAccountPayload.newBuilder().setVirtualPaymentAddress(this.virtualPaymentAddress);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setUpiAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static UpiAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.UpiAccountPayload upiAccountPayloadPB = countryBasedPaymentAccountPayload.getUpiAccountPayload();
        return new UpiAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>(countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), upiAccountPayloadPB.getVirtualPaymentAddress(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.upi.virtualPaymentAddress") + " " + this.virtualPaymentAddress;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.virtualPaymentAddress.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpiAccountPayload)) {
            return false;
        }
        UpiAccountPayload other = (UpiAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$virtualPaymentAddress = this.getVirtualPaymentAddress();
        String other$virtualPaymentAddress = other.getVirtualPaymentAddress();
        return !(this$virtualPaymentAddress == null ? other$virtualPaymentAddress != null : !this$virtualPaymentAddress.equals(other$virtualPaymentAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpiAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $virtualPaymentAddress = this.getVirtualPaymentAddress();
        result = result * 59 + ($virtualPaymentAddress == null ? 43 : $virtualPaymentAddress.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UpiAccountPayload(virtualPaymentAddress=" + this.getVirtualPaymentAddress() + ")";
    }

    public void setVirtualPaymentAddress(String virtualPaymentAddress) {
        this.virtualPaymentAddress = virtualPaymentAddress;
    }

    public String getVirtualPaymentAddress() {
        return this.virtualPaymentAddress;
    }
}

