/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VenmoAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(VenmoAccountPayload.class);
    private String emailOrMobileNrOrUsername = "";

    public VenmoAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private VenmoAccountPayload(String paymentMethod, String id, String emailOrMobileNrOrUsername, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNrOrUsername = emailOrMobileNrOrUsername;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setVenmoAccountPayload(protobuf.VenmoAccountPayload.newBuilder().setEmailOrMobileNrOrUsername(this.emailOrMobileNrOrUsername)).build();
    }

    public static VenmoAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new VenmoAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getVenmoAccountPayload().getEmailOrMobileNrOrUsername(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.getWithCol("payment.email.mobile.username") + " " + this.emailOrMobileNrOrUsername;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.emailOrMobileNrOrUsername.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VenmoAccountPayload)) {
            return false;
        }
        VenmoAccountPayload other = (VenmoAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNrOrUsername = this.getEmailOrMobileNrOrUsername();
        String other$emailOrMobileNrOrUsername = other.getEmailOrMobileNrOrUsername();
        return !(this$emailOrMobileNrOrUsername == null ? other$emailOrMobileNrOrUsername != null : !this$emailOrMobileNrOrUsername.equals(other$emailOrMobileNrOrUsername));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VenmoAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNrOrUsername = this.getEmailOrMobileNrOrUsername();
        result = result * 59 + ($emailOrMobileNrOrUsername == null ? 43 : $emailOrMobileNrOrUsername.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "VenmoAccountPayload(emailOrMobileNrOrUsername=" + this.getEmailOrMobileNrOrUsername() + ")";
    }

    public void setEmailOrMobileNrOrUsername(String emailOrMobileNrOrUsername) {
        this.emailOrMobileNrOrUsername = emailOrMobileNrOrUsername;
    }

    public String getEmailOrMobileNrOrUsername() {
        return this.emailOrMobileNrOrUsername;
    }
}

