/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZelleAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(ZelleAccountPayload.class);
    private String emailOrMobileNr = "";
    private String holderName = "";

    public ZelleAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private ZelleAccountPayload(String paymentMethod, String id, String emailOrMobileNr, String holderName, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNr = emailOrMobileNr;
        this.holderName = holderName;
    }

    @Override
    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setZelleAccountPayload(protobuf.ZelleAccountPayload.newBuilder().setEmailOrMobileNr(this.emailOrMobileNr).setHolderName(this.holderName)).build();
    }

    public static ZelleAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new ZelleAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getZelleAccountPayload().getEmailOrMobileNr(), proto.getZelleAccountPayload().getHolderName(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.getWithCol("payment.emailOrMobile") + " " + this.emailOrMobileNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + Res.getWithCol("payment.emailOrMobile") + " " + this.emailOrMobileNr;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.emailOrMobileNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZelleAccountPayload)) {
            return false;
        }
        ZelleAccountPayload other = (ZelleAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNr = this.getEmailOrMobileNr();
        String other$emailOrMobileNr = other.getEmailOrMobileNr();
        if (this$emailOrMobileNr == null ? other$emailOrMobileNr != null : !this$emailOrMobileNr.equals(other$emailOrMobileNr)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        return !(this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZelleAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNr = this.getEmailOrMobileNr();
        result = result * 59 + ($emailOrMobileNr == null ? 43 : $emailOrMobileNr.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ZelleAccountPayload(emailOrMobileNr=" + this.getEmailOrMobileNr() + ", holderName=" + this.getHolderName() + ")";
    }

    public void setEmailOrMobileNr(String emailOrMobileNr) {
        this.emailOrMobileNr = emailOrMobileNr;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getEmailOrMobileNr() {
        return this.emailOrMobileNr;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }
}

