/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.BankUtil;
import haveno.core.locale.Res;
import haveno.core.payment.validation.BankValidator;
import haveno.core.util.validation.InputValidator;

public final class BankIdValidator
extends BankValidator {
    public BankIdValidator(String countryCode) {
        super(countryCode);
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        switch (this.countryCode) {
            case "CA": {
                int length = 3;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.bankIdNumber", this.getLabel(), length));
            }
            case "HK": {
                int length = 3;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.bankIdNumber", this.getLabel(), length));
            }
        }
        return super.validate(input);
    }

    private String getLabel() {
        String label = BankUtil.getBankIdLabel(this.countryCode);
        return label.substring(0, label.length() - 1);
    }
}

