/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.BankUtil;
import haveno.core.locale.Res;
import haveno.core.payment.validation.BankValidator;
import haveno.core.util.validation.InputValidator;

public final class BranchIdValidator
extends BankValidator {
    public BranchIdValidator(String countryCode) {
        super(countryCode);
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        switch (this.countryCode) {
            case "GB": {
                int length = 6;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeNumber", this.getLabel(), length));
            }
            case "US": {
                int length = 9;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeNumber", this.getLabel(), length));
            }
            case "BR": {
                if (this.isStringInRange(input, 2, 6)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeChars", this.getLabel(), "2 - 6"));
            }
            case "AU": {
                int length = 6;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeChars", this.getLabel(), length));
            }
            case "CA": {
                int length = 5;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeNumber", this.getLabel(), length));
            }
            case "AR": {
                int length = 4;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeNumber", this.getLabel(), length));
            }
        }
        return super.validate(input);
    }

    private String getLabel() {
        return BankUtil.getBranchIdLabel(this.countryCode);
    }
}

