/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import java.math.BigInteger;
import java.util.Locale;

public class IBANValidator
extends InputValidator {
    private String restrictToCountry = "";

    public IBANValidator() {
    }

    public IBANValidator(String restrictToCountry) {
        this.restrictToCountry = restrictToCountry;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        if (this.isStringInRange(input, 15, 34)) {
            char ch;
            if (!Character.isLetter((input = input.toUpperCase(Locale.ROOT)).charAt(0)) || !Character.isLetter(input.charAt(1))) {
                return new InputValidator.ValidationResult(false, Res.get("validation.iban.invalidCountryCode"));
            }
            if (this.restrictToCountry.length() > 0 && !this.restrictToCountry.equals(input.substring(0, 2))) {
                return new InputValidator.ValidationResult(false, Res.get("validation.iban.invalidCountryCode"));
            }
            if (!Character.isDigit(input.charAt(2)) || !Character.isDigit(input.charAt(3))) {
                return new InputValidator.ValidationResult(false, Res.get("validation.iban.checkSumNotNumeric"));
            }
            String input2 = input.substring(4, input.length()) + input.substring(0, 4);
            int charCount = 0;
            for (int k = 0; k < input2.length(); ++k) {
                ch = input2.charAt(k);
                if (Character.isLetter(ch)) {
                    ++charCount;
                    continue;
                }
                if (Character.isDigit(ch)) continue;
                return new InputValidator.ValidationResult(false, Res.get("validation.iban.nonNumericChars"));
            }
            char[] charArray = new char[input2.length() + charCount];
            int i = 0;
            for (int k = 0; k < input2.length(); ++k) {
                ch = input2.charAt(k);
                if (Character.isLetter(ch)) {
                    int tmp = ch - 55;
                    String s2 = Integer.toString(tmp);
                    charArray[i++] = s2.charAt(0);
                    charArray[i++] = s2.charAt(1);
                    continue;
                }
                charArray[i++] = ch;
            }
            BigInteger bigInt = new BigInteger(new String(charArray));
            int result = bigInt.mod(new BigInteger(Integer.toString(97))).intValue();
            if (result == 1) {
                return new InputValidator.ValidationResult(true);
            }
            return new InputValidator.ValidationResult(false, Res.get("validation.iban.checkSumInvalid"));
        }
        return new InputValidator.ValidationResult(false, Res.get("validation.iban.invalidLength"));
    }

    public void setRestrictToCountry(String restrictToCountry) {
        this.restrictToCountry = restrictToCountry;
    }
}

