/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.payment.validation.InteracETransferAnswerValidator;
import haveno.core.payment.validation.InteracETransferQuestionValidator;
import haveno.core.util.validation.InputValidator;
import org.apache.commons.lang3.StringUtils;

public final class InteracETransferValidator
extends InputValidator {
    private static final String[] NPAS = new String[]{"204", "226", "236", "249", "250", "289", "306", "343", "365", "403", "416", "418", "431", "437", "438", "450", "506", "514", "519", "548", "579", "581", "587", "604", "613", "639", "647", "705", "709", "778", "780", "782", "807", "819", "825", "867", "873", "902", "905"};
    private final EmailValidator emailValidator;
    public final InputValidator answerValidator;
    public final InputValidator questionValidator;

    @Inject
    public InteracETransferValidator(EmailValidator emailValidator, InteracETransferQuestionValidator questionValidator, InteracETransferAnswerValidator answerValidator) {
        this.emailValidator = emailValidator;
        this.questionValidator = questionValidator;
        this.answerValidator = answerValidator;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = this.validateIfNotEmpty(input);
        if (!result.isValid) {
            return result;
        }
        InputValidator.ValidationResult emailResult = this.emailValidator.validate(input);
        if (emailResult.isValid) {
            return emailResult;
        }
        return this.validatePhoneNumber(input);
    }

    private InputValidator.ValidationResult validatePhoneNumber(String input) {
        if (input.matches("\\+?1[ -]?\\d{3}[ -]?\\d{3}[ -]?\\d{4}")) {
            input = input.replace("+", "");
            input = StringUtils.deleteWhitespace(input);
            input = input.replace("-", "");
            String inputAreaCode = input.substring(1, 4);
            for (String s2 : NPAS) {
                if (inputAreaCode.compareTo(s2) != 0) continue;
                return new InputValidator.ValidationResult(true);
            }
            return new InputValidator.ValidationResult(false, Res.get("validation.interacETransfer.invalidAreaCode"));
        }
        return new InputValidator.ValidationResult(false, Res.get("validation.interacETransfer.invalidPhone"));
    }
}

