/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.core.payment.JapanBankData;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.RegexValidator;

public final class JapanBankAccountNameValidator
extends InputValidator {
    private LengthValidator lengthValidator;
    private RegexValidator regexValidator;

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = super.validate(input);
        if (result.isValid) {
            result = this.lengthValidator.validate(input);
        }
        if (result.isValid) {
            result = this.regexValidator.validate(input);
        }
        return result;
    }

    @Inject
    public JapanBankAccountNameValidator(LengthValidator lengthValidator, RegexValidator regexValidator) {
        lengthValidator.setMinLength(1);
        lengthValidator.setMaxLength(40);
        this.lengthValidator = lengthValidator;
        regexValidator.setPattern(JapanBankData.getString("japanese.validation.regex"));
        regexValidator.setErrorMessage(JapanBankData.getString("japanese.validation.error"));
        this.regexValidator = regexValidator;
    }
}

