/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;

public class LengthValidator
extends InputValidator {
    private int minLength;
    private int maxLength;

    public LengthValidator() {
        this(0, Integer.MAX_VALUE);
    }

    public LengthValidator(int min2, int max) {
        this.minLength = min2;
        this.maxLength = max;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        int length;
        InputValidator.ValidationResult result = new InputValidator.ValidationResult(true);
        int n = length = input == null ? 0 : input.length();
        if (this.minLength == this.maxLength) {
            if (length != this.minLength) {
                result = new InputValidator.ValidationResult(false, Res.get("validation.fixedLength", this.minLength));
            }
        } else if (length < this.minLength || length > this.maxLength) {
            result = new InputValidator.ValidationResult(false, Res.get("validation.length", this.minLength, this.maxLength));
        }
        return result;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

