/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.NumberValidator;
import javax.annotation.Nullable;

public class PercentageNumberValidator
extends NumberValidator {
    @Nullable
    protected Double maxValue;

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = this.validateIfNotEmpty(input);
        if (result.isValid) {
            input = input.replace("%", "");
            input = this.cleanInput(input);
            result = this.validateIfNumber(input);
        }
        return result.and(this.validateIfNotExceedsMaxValue(input));
    }

    private InputValidator.ValidationResult validateIfNotExceedsMaxValue(String input) {
        try {
            double value = Double.parseDouble(input);
            if (this.maxValue != null && value > this.maxValue) {
                return new InputValidator.ValidationResult(false, Res.get("validation.inputTooLarge", this.maxValue));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t2) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t2.getMessage()));
        }
    }

    public void setMaxValue(@Nullable Double maxValue) {
        this.maxValue = maxValue;
    }
}

