/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.presentation;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.core.api.model.XmrBalanceInfo;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.Balances;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancePresentation {
    private static final Logger log = LoggerFactory.getLogger(BalancePresentation.class);
    private final StringProperty availableBalance = new SimpleStringProperty();
    private final StringProperty pendingBalance = new SimpleStringProperty();
    private final StringProperty reservedBalance = new SimpleStringProperty();

    @Inject
    public BalancePresentation(Balances balances) {
        balances.getUpdateCounter().addListener((observable2, oldValue, newValue) -> {
            XmrBalanceInfo info = balances.getBalances();
            UserThread.execute(() -> {
                this.availableBalance.set(HavenoUtils.formatXmr(info.getAvailableBalance(), true));
                this.pendingBalance.set(HavenoUtils.formatXmr(info.getPendingBalance(), true));
                this.reservedBalance.set(HavenoUtils.formatXmr(info.getReservedBalance(), true));
            });
        });
    }

    public StringProperty getAvailableBalance() {
        return this.availableBalance;
    }

    public StringProperty getPendingBalance() {
        return this.pendingBalance;
    }

    public StringProperty getReservedBalance() {
        return this.reservedBalance;
    }
}

