/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.presentation;

import com.google.inject.Inject;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.refund.RefundManager;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jetbrains.annotations.NotNull;

public class SupportTicketsPresentation {
    private final StringProperty numOpenSupportTickets = new SimpleStringProperty();
    private final BooleanProperty showOpenSupportTicketsNotification = new SimpleBooleanProperty();
    @NotNull
    private final ArbitrationManager arbitrationManager;
    @NotNull
    private final MediationManager mediationManager;
    @NotNull
    private final RefundManager refundManager;

    @Inject
    public SupportTicketsPresentation(ArbitrationManager arbitrationManager, MediationManager mediationManager, RefundManager refundManager) {
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.refundManager = refundManager;
        arbitrationManager.getNumOpenDisputes().addListener((observable2, oldValue, newValue) -> this.onChange());
        mediationManager.getNumOpenDisputes().addListener((observable2, oldValue, newValue) -> this.onChange());
        refundManager.getNumOpenDisputes().addListener((observable2, oldValue, newValue) -> this.onChange());
    }

    private void onChange() {
        int supportTickets = this.arbitrationManager.getNumOpenDisputes().get() + this.mediationManager.getNumOpenDisputes().get() + this.refundManager.getNumOpenDisputes().get();
        this.numOpenSupportTickets.set(String.valueOf(supportTickets));
        this.showOpenSupportTicketsNotification.set(supportTickets > 0);
    }

    public StringProperty getNumOpenSupportTickets() {
        return this.numOpenSupportTickets;
    }

    public BooleanProperty getShowOpenSupportTicketsNotification() {
        return this.showOpenSupportTicketsNotification;
    }
}

