/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.presentation;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.core.trade.TradeManager;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class TradePresentation {
    private final StringProperty numPendingTrades = new SimpleStringProperty();
    private final BooleanProperty showPendingTradesNotification = new SimpleBooleanProperty();

    @Inject
    public TradePresentation(TradeManager tradeManager) {
        tradeManager.getNumPendingTrades().addListener((observable2, oldValue, newValue) -> {
            long numPendingTrades = (Long)newValue;
            UserThread.execute(() -> {
                if (numPendingTrades > 0L) {
                    this.numPendingTrades.set(String.valueOf(numPendingTrades));
                }
                this.showPendingTradesNotification.set(numPendingTrades > 0L);
            });
        });
    }

    public StringProperty getNumPendingTrades() {
        return this.numPendingTrades;
    }

    public BooleanProperty getShowPendingTradesNotification() {
        return this.showPendingTradesNotification;
    }
}

