/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidersRepository {
    private static final Logger log = LoggerFactory.getLogger(ProvidersRepository.class);
    private static final String DEFAULT_LOCAL_NODE = "http://localhost:8078/";
    private static final List<String> DEFAULT_NODES = Arrays.asList("http://elaxlgigphpicy5q7pi5wkz2ko2vgjbq4576vic7febmx4xcxvk6deqd.onion/", "http://lrrgpezvdrbpoqvkavzobmj7dr2otxc5x6wgktrw337bk6mxsvfp5yid.onion/", "http://2c6y3sqmknakl3fkuwh4tjhxb2q5isr53dnfcqs33vt3y7elujc6tyad.onion/");
    private final Config config;
    private final List<String> providersFromProgramArgs;
    private final boolean useLocalhostForP2P;
    private List<String> providerList;
    private String baseUrl = "";
    @Nullable
    private List<String> bannedNodes;
    private int index = -1;

    @Inject
    public ProvidersRepository(Config config, @Named(value="providers") List<String> providers, @Named(value="useLocalhostForP2P") boolean useLocalhostForP2P) {
        this.config = config;
        this.providersFromProgramArgs = providers;
        this.useLocalhostForP2P = useLocalhostForP2P;
        Collections.shuffle(DEFAULT_NODES);
        this.applyBannedNodes(config.bannedPriceRelayNodes);
    }

    public void applyBannedNodes(@Nullable List<String> bannedNodes) {
        this.bannedNodes = bannedNodes;
        this.fillProviderList();
        if (this.baseUrl.isEmpty() || this.isBanned(this.baseUrl)) {
            this.selectNextProviderBaseUrl();
        }
        if (bannedNodes != null && !bannedNodes.isEmpty()) {
            log.info("Excluded provider nodes from filter: nodes={}, selected provider baseUrl={}, providerList={}", bannedNodes, this.baseUrl, this.providerList);
        }
    }

    public synchronized boolean selectNextProviderBaseUrl() {
        boolean looped = false;
        if (!this.providerList.isEmpty()) {
            ++this.index;
            if (this.index >= this.providerList.size()) {
                this.index = 0;
                looped = true;
            }
            this.baseUrl = this.providerList.get(this.index);
            log.info("Selected price provider: " + this.baseUrl);
            if (this.providerList.size() == 1 && this.config.baseCurrencyNetwork.isMainnet()) {
                log.warn("We only have one provider");
            }
        } else {
            this.baseUrl = "";
            log.warn("We do not have any providers. That can be if all providers are filtered or providersFromProgramArgs is set but empty. bannedNodes={}. providersFromProgramArgs={}", (Object)this.bannedNodes, (Object)this.providersFromProgramArgs);
        }
        return looped;
    }

    private void fillProviderList() {
        List<String> providers;
        if (this.providersFromProgramArgs.isEmpty()) {
            if (this.useLocalhostForP2P) {
                providers = List.of(DEFAULT_LOCAL_NODE, "https://price.haveno.network/", "http://173.230.142.36:8078/");
            } else {
                providers = new ArrayList<String>();
                providers.addAll(DEFAULT_NODES);
            }
        } else {
            providers = this.providersFromProgramArgs;
        }
        this.providerList = providers.stream().filter(e -> !this.isBanned((String)e)).map(e -> e.endsWith("/") ? e : e + "/").map(e -> e.startsWith("http") ? e : "http://" + e).collect(Collectors.toList());
    }

    private boolean isBanned(String provider) {
        if (this.bannedNodes == null) {
            return false;
        }
        return this.bannedNodes.stream().anyMatch(e -> provider.replace("http://", "").replace("/", "").replace(".onion", "").equals(e));
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Nullable
    public List<String> getBannedNodes() {
        return this.bannedNodes;
    }
}

