/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider.fee;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.common.util.Tuple2;
import haveno.core.provider.FeeHttpClient;
import haveno.core.provider.HttpClientProvider;
import haveno.core.provider.ProvidersRepository;
import haveno.network.http.HttpClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeeProvider
extends HttpClientProvider {
    private static final Logger log = LoggerFactory.getLogger(FeeProvider.class);

    @Inject
    public FeeProvider(FeeHttpClient httpClient, ProvidersRepository providersRepository) {
        super(httpClient, providersRepository.getBaseUrl(), false);
    }

    public Tuple2<Map<String, Long>, Map<String, Long>> getFees() throws IOException {
        String json = this.httpClient.get("getFees", "User-Agent", "haveno/1.1.1");
        LinkedTreeMap linkedTreeMap = new Gson().fromJson(json, LinkedTreeMap.class);
        HashMap<String, Long> tsMap = new HashMap<String, Long>();
        tsMap.put("bitcoinFeesTs", ((Double)linkedTreeMap.get("bitcoinFeesTs")).longValue());
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            LinkedTreeMap dataMap = (LinkedTreeMap)linkedTreeMap.get("dataMap");
            Long btcTxFee = ((Double)dataMap.get("btcTxFee")).longValue();
            Long btcMinTxFee = dataMap.get("btcMinTxFee") != null ? ((Double)dataMap.get("btcMinTxFee")).longValue() : Config.baseCurrencyNetwork().getDefaultMinFeePerVbyte();
            map.put("btcTxFee", btcTxFee);
            map.put("btcMinTxFee", btcMinTxFee);
        }
        catch (Throwable t2) {
            log.error("Error getting fees: {}\n", (Object)t2.getMessage(), (Object)t2);
        }
        return new Tuple2<Map<String, Long>, Map<String, Long>>(tsMap, map);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

