/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider.fee;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.provider.fee.FeeProvider;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeeRequest {
    private static final Logger log = LoggerFactory.getLogger(FeeRequest.class);
    private static final ListeningExecutorService executorService = Utilities.getListeningExecutorService("FeeRequest", 3, 5, 600L);

    public SettableFuture<Tuple2<Map<String, Long>, Map<String, Long>>> getFees(final FeeProvider provider) {
        final SettableFuture<Tuple2<Map<String, Long>, Map<String, Long>>> resultFuture = SettableFuture.create();
        Future future = executorService.submit(() -> {
            Thread.currentThread().setName("FeeRequest @ " + provider.getHttpClient().getBaseUrl());
            return provider.getFees();
        });
        Futures.addCallback(future, new FutureCallback<Tuple2<Map<String, Long>, Map<String, Long>>>(){

            @Override
            public void onSuccess(Tuple2<Map<String, Long>, Map<String, Long>> feeData) {
                log.debug("Received feeData of {}\nfrom provider {}", (Object)feeData, (Object)provider);
                resultFuture.set(feeData);
            }

            @Override
            public void onFailure(@NotNull Throwable throwable) {
                resultFuture.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return resultFuture;
    }
}

