/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider.price;

import java.time.Instant;

public final class MarketPrice {
    public static final long MARKET_PRICE_MAX_AGE_SEC = 1800L;
    private final String currencyCode;
    private final double price;
    private final long timestampSec;
    private final boolean isExternallyProvidedPrice;

    public MarketPrice(String currencyCode, double price, long timestampSec, boolean isExternallyProvidedPrice) {
        this.currencyCode = currencyCode;
        this.price = price;
        this.timestampSec = timestampSec;
        this.isExternallyProvidedPrice = isExternallyProvidedPrice;
    }

    public boolean isPriceAvailable() {
        return this.price > 0.0;
    }

    public boolean isRecentPriceAvailable() {
        return this.isPriceAvailable() && this.timestampSec > Instant.now().getEpochSecond() - 1800L;
    }

    public boolean isRecentExternalPriceAvailable() {
        return this.isExternallyProvidedPrice && this.isRecentPriceAvailable();
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public double getPrice() {
        return this.price;
    }

    public long getTimestampSec() {
        return this.timestampSec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketPrice)) {
            return false;
        }
        MarketPrice other = (MarketPrice)o;
        if (Double.compare(this.getPrice(), other.getPrice()) != 0) {
            return false;
        }
        if (this.getTimestampSec() != other.getTimestampSec()) {
            return false;
        }
        if (this.isExternallyProvidedPrice() != other.isExternallyProvidedPrice()) {
            return false;
        }
        String this$currencyCode = this.getCurrencyCode();
        String other$currencyCode = other.getCurrencyCode();
        return !(this$currencyCode == null ? other$currencyCode != null : !this$currencyCode.equals(other$currencyCode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $price = Double.doubleToLongBits(this.getPrice());
        result = result * 59 + (int)($price >>> 32 ^ $price);
        long $timestampSec = this.getTimestampSec();
        result = result * 59 + (int)($timestampSec >>> 32 ^ $timestampSec);
        result = result * 59 + (this.isExternallyProvidedPrice() ? 79 : 97);
        String $currencyCode = this.getCurrencyCode();
        result = result * 59 + ($currencyCode == null ? 43 : $currencyCode.hashCode());
        return result;
    }

    public String toString() {
        return "MarketPrice(currencyCode=" + this.getCurrencyCode() + ", price=" + this.getPrice() + ", timestampSec=" + this.getTimestampSec() + ", isExternallyProvidedPrice=" + this.isExternallyProvidedPrice() + ")";
    }

    public boolean isExternallyProvidedPrice() {
        return this.isExternallyProvidedPrice;
    }
}

