/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider.price;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.provider.HttpClientProvider;
import haveno.core.provider.price.MarketPrice;
import haveno.network.http.HttpClient;
import haveno.network.p2p.P2PService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceProvider
extends HttpClientProvider {
    private static final Logger log = LoggerFactory.getLogger(PriceProvider.class);
    private boolean shutDownRequested;

    public PriceProvider(HttpClient httpClient, String baseUrl) {
        super(httpClient, baseUrl, false);
    }

    public synchronized Map<String, MarketPrice> getAll() throws IOException {
        if (this.shutDownRequested) {
            return new HashMap<String, MarketPrice>();
        }
        HashMap<String, MarketPrice> marketPriceMap = new HashMap<String, MarketPrice>();
        String hsVersion = "";
        if (P2PService.getMyNodeAddress() != null) {
            hsVersion = P2PService.getMyNodeAddress().getHostName().length() > 22 ? ", HSv3" : ", HSv2";
        }
        String json = this.httpClient.get("getAllMarketPrices", "User-Agent", "haveno/1.1.1" + hsVersion);
        LinkedTreeMap map = new Gson().fromJson(json, LinkedTreeMap.class);
        ArrayList list = (ArrayList)map.get("data");
        list.forEach(obj -> {
            try {
                LinkedTreeMap treeMap = (LinkedTreeMap)obj;
                String baseCurrencyCode = (String)treeMap.get("baseCurrencyCode");
                String counterCurrencyCode = (String)treeMap.get("counterCurrencyCode");
                String currencyCode = baseCurrencyCode.equals("XMR") ? counterCurrencyCode : baseCurrencyCode;
                currencyCode = CurrencyUtil.getCurrencyCodeBase(currencyCode);
                double price = (Double)treeMap.get("price");
                long timestampSec = MathUtils.doubleToLong((Double)treeMap.get("timestampSec"));
                marketPriceMap.put(currencyCode, new MarketPrice(currencyCode, price, timestampSec, true));
            }
            catch (Throwable t2) {
                log.error("Error getting all prices: {}\n", (Object)t2.getMessage(), (Object)t2);
            }
        });
        return marketPriceMap;
    }

    public String getBaseUrl() {
        return this.httpClient.getBaseUrl();
    }

    public void shutDown() {
        this.shutDownRequested = true;
        this.httpClient.shutDown();
    }
}

