/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider.price;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.util.Utilities;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceProvider;
import haveno.core.provider.price.PriceRequestException;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceRequest {
    private static final Logger log = LoggerFactory.getLogger(PriceRequest.class);
    private final ListeningExecutorService executorService = Utilities.getListeningExecutorService("PriceRequest", 3, 5, 600L);
    @Nullable
    private PriceProvider provider;
    private boolean shutDownRequested;

    public SettableFuture<Map<String, MarketPrice>> requestAllPrices(final PriceProvider provider) {
        this.provider = provider;
        final String baseUrl = provider.getBaseUrl();
        final SettableFuture<Map<String, MarketPrice>> resultFuture = SettableFuture.create();
        Future future = this.executorService.submit(() -> {
            Thread.currentThread().setName("PriceRequest @ " + baseUrl);
            return provider.getAll();
        });
        Futures.addCallback(future, new FutureCallback<Map<String, MarketPrice>>(){

            @Override
            public void onSuccess(Map<String, MarketPrice> marketPriceTuple) {
                log.trace("Received marketPriceTuple of {}\nfrom provider {}", (Object)marketPriceTuple, (Object)provider);
                if (!PriceRequest.this.shutDownRequested) {
                    resultFuture.set(marketPriceTuple);
                }
            }

            @Override
            public void onFailure(@NotNull Throwable throwable) {
                if (!PriceRequest.this.shutDownRequested) {
                    resultFuture.setException(new PriceRequestException(throwable, baseUrl));
                }
            }
        }, MoreExecutors.directExecutor());
        return resultFuture;
    }

    public void shutDown() {
        this.shutDownRequested = true;
        if (this.provider != null) {
            this.provider.shutDown();
        }
        Utilities.shutdownAndAwaitTermination(this.executorService, 1L, TimeUnit.SECONDS);
    }
}

