/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import com.google.protobuf.ByteString;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.CollectionUtils;
import haveno.common.util.ExtraDataMapValidator;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.mediation.FileTransferReceiver;
import haveno.core.support.dispute.mediation.FileTransferSender;
import haveno.core.support.dispute.mediation.FileTransferSession;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.Contract;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.NetworkNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Dispute;

public final class Dispute
implements NetworkPayload,
PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(Dispute.class);
    private final String tradeId;
    private final String id;
    private final int traderId;
    private final boolean disputeOpenerIsBuyer;
    private final boolean disputeOpenerIsMaker;
    private final PubKeyRing traderPubKeyRing;
    private final long tradeDate;
    private final long tradePeriodEnd;
    private final Contract contract;
    @Nullable
    private final byte[] contractHash;
    @Nullable
    private final byte[] payoutTxSerialized;
    @Nullable
    private final String payoutTxId;
    private String contractAsJson;
    @Nullable
    private final byte[] makerContractSignature;
    @Nullable
    private final byte[] takerContractSignature;
    private final PubKeyRing agentPubKeyRing;
    private final boolean isSupportTicket;
    private final ObservableList<ChatMessage> chatMessages = FXCollections.observableArrayList();
    private final ObjectProperty<DisputeResult> disputeResultProperty = new SimpleObjectProperty<DisputeResult>();
    private final long openingDate;
    @Nullable
    private String disputePayoutTxId;
    private SupportType supportType;
    @Nullable
    private String mediatorsDisputeResult;
    @Nullable
    private String delayedPayoutTxId;
    @Nullable
    private String donationAddressOfDelayedPayoutTx;
    private State disputeState = State.NEW;
    @Nullable
    private Map<String, String> extraDataMap;
    private boolean isOpener;
    @Nullable
    private PaymentAccountPayload makerPaymentAccountPayload;
    @Nullable
    private PaymentAccountPayload takerPaymentAccountPayload;
    @Nullable
    private transient String uid;
    private transient long payoutTxConfirms = -1L;
    private final transient BooleanProperty isClosedProperty = new SimpleBooleanProperty();
    private final transient IntegerProperty badgeCountProperty = new SimpleIntegerProperty();
    private transient FileTransferReceiver fileTransferSession = null;

    public FileTransferReceiver createOrGetFileTransferReceiver(NetworkNode networkNode, NodeAddress peerNodeAddress, FileTransferSession.FtpCallback callback) throws IOException {
        if (this.fileTransferSession == null) {
            this.fileTransferSession = new FileTransferReceiver(networkNode, peerNodeAddress, this.tradeId, this.traderId, this.getRoleStringForLogFile(), callback);
        }
        return this.fileTransferSession;
    }

    public FileTransferSender createFileTransferSender(NetworkNode networkNode, NodeAddress peerNodeAddress, FileTransferSession.FtpCallback callback) {
        return new FileTransferSender(networkNode, peerNodeAddress, this.tradeId, this.traderId, this.getRoleStringForLogFile(), false, callback);
    }

    public Dispute(long openingDate, String tradeId, int traderId, boolean isOpener, boolean disputeOpenerIsBuyer, boolean disputeOpenerIsMaker, PubKeyRing traderPubKeyRing, long tradeDate, long tradePeriodEnd, Contract contract, @Nullable byte[] contractHash, @Nullable byte[] payoutTxSerialized, @Nullable String payoutTxId, String contractAsJson, @Nullable byte[] makerContractSignature, @Nullable byte[] takerContractSignature, @Nullable PaymentAccountPayload makerPaymentAccountPayload, @Nullable PaymentAccountPayload takerPaymentAccountPayload, PubKeyRing agentPubKeyRing, boolean isSupportTicket, SupportType supportType) {
        this.openingDate = openingDate;
        this.tradeId = tradeId;
        this.traderId = traderId;
        this.isOpener = isOpener;
        this.disputeOpenerIsBuyer = disputeOpenerIsBuyer;
        this.disputeOpenerIsMaker = disputeOpenerIsMaker;
        this.traderPubKeyRing = traderPubKeyRing;
        this.tradeDate = tradeDate;
        this.tradePeriodEnd = tradePeriodEnd;
        this.contract = contract;
        this.contractHash = contractHash;
        this.payoutTxSerialized = payoutTxSerialized;
        this.payoutTxId = payoutTxId;
        this.contractAsJson = contractAsJson;
        this.makerContractSignature = makerContractSignature;
        this.takerContractSignature = takerContractSignature;
        this.makerPaymentAccountPayload = makerPaymentAccountPayload;
        this.takerPaymentAccountPayload = takerPaymentAccountPayload;
        this.agentPubKeyRing = agentPubKeyRing;
        this.isSupportTicket = isSupportTicket;
        this.supportType = supportType;
        this.id = tradeId + "_" + traderId;
        this.uid = UUID.randomUUID().toString();
        this.refreshAlertLevel(true);
    }

    @Override
    public protobuf.Dispute toProtoMessage() {
        ArrayList<ChatMessage> clonedChatMessages = new ArrayList<ChatMessage>(this.chatMessages);
        Dispute.Builder builder = protobuf.Dispute.newBuilder().setTradeId(this.tradeId).setTraderId(this.traderId).setIsOpener(this.isOpener).setDisputeOpenerIsBuyer(this.disputeOpenerIsBuyer).setDisputeOpenerIsMaker(this.disputeOpenerIsMaker).setTraderPubKeyRing(this.traderPubKeyRing.toProtoMessage()).setTradeDate(this.tradeDate).setTradePeriodEnd(this.tradePeriodEnd).setContract(this.contract.toProtoMessage()).setContractAsJson(this.contractAsJson).setAgentPubKeyRing(this.agentPubKeyRing.toProtoMessage()).setIsSupportTicket(this.isSupportTicket).addAllChatMessage(clonedChatMessages.stream().map(msg -> msg.toProtoNetworkEnvelope().getChatMessage()).collect(Collectors.toList())).setIsClosed(this.isClosed()).setOpeningDate(this.openingDate).setState(State.toProtoMessage(this.disputeState)).setId(this.id);
        Optional.ofNullable(this.contractHash).ifPresent(e -> builder.setContractHash(ByteString.copyFrom(e)));
        Optional.ofNullable(this.payoutTxSerialized).ifPresent(e -> builder.setPayoutTxSerialized(ByteString.copyFrom(e)));
        Optional.ofNullable(this.payoutTxId).ifPresent(builder::setPayoutTxId);
        Optional.ofNullable(this.disputePayoutTxId).ifPresent(builder::setDisputePayoutTxId);
        Optional.ofNullable(this.makerContractSignature).ifPresent(e -> builder.setMakerContractSignature(ByteString.copyFrom(e)));
        Optional.ofNullable(this.takerContractSignature).ifPresent(e -> builder.setTakerContractSignature(ByteString.copyFrom(e)));
        Optional.ofNullable(this.makerPaymentAccountPayload).ifPresent(e -> builder.setMakerPaymentAccountPayload((protobuf.PaymentAccountPayload)this.makerPaymentAccountPayload.toProtoMessage()));
        Optional.ofNullable(this.takerPaymentAccountPayload).ifPresent(e -> builder.setTakerPaymentAccountPayload((protobuf.PaymentAccountPayload)this.takerPaymentAccountPayload.toProtoMessage()));
        Optional.ofNullable((DisputeResult)this.disputeResultProperty.get()).ifPresent(result -> builder.setDisputeResult(((DisputeResult)this.disputeResultProperty.get()).toProtoMessage()));
        Optional.ofNullable(this.supportType).ifPresent(result -> builder.setSupportType(SupportType.toProtoMessage(this.supportType)));
        Optional.ofNullable(this.mediatorsDisputeResult).ifPresent(result -> builder.setMediatorsDisputeResult(this.mediatorsDisputeResult));
        Optional.ofNullable(this.delayedPayoutTxId).ifPresent(result -> builder.setDelayedPayoutTxId(this.delayedPayoutTxId));
        Optional.ofNullable(this.donationAddressOfDelayedPayoutTx).ifPresent(result -> builder.setDonationAddressOfDelayedPayoutTx(this.donationAddressOfDelayedPayoutTx));
        Optional.ofNullable(this.getExtraDataMap()).ifPresent(builder::putAllExtraData);
        return builder.build();
    }

    public static Dispute fromProto(protobuf.Dispute proto, CoreProtoResolver coreProtoResolver) {
        String donationAddressOfDelayedPayoutTx;
        String delayedPayoutTxId;
        Dispute dispute = new Dispute(proto.getOpeningDate(), proto.getTradeId(), proto.getTraderId(), proto.getIsOpener(), proto.getDisputeOpenerIsBuyer(), proto.getDisputeOpenerIsMaker(), PubKeyRing.fromProto(proto.getTraderPubKeyRing()), proto.getTradeDate(), proto.getTradePeriodEnd(), Contract.fromProto(proto.getContract(), coreProtoResolver), ProtoUtil.byteArrayOrNullFromProto(proto.getContractHash()), ProtoUtil.byteArrayOrNullFromProto(proto.getPayoutTxSerialized()), ProtoUtil.stringOrNullFromProto(proto.getPayoutTxId()), proto.getContractAsJson(), ProtoUtil.byteArrayOrNullFromProto(proto.getMakerContractSignature()), ProtoUtil.byteArrayOrNullFromProto(proto.getTakerContractSignature()), proto.hasMakerPaymentAccountPayload() ? coreProtoResolver.fromProto(proto.getMakerPaymentAccountPayload()) : null, proto.hasTakerPaymentAccountPayload() ? coreProtoResolver.fromProto(proto.getTakerPaymentAccountPayload()) : null, PubKeyRing.fromProto(proto.getAgentPubKeyRing()), proto.getIsSupportTicket(), SupportType.fromProto(proto.getSupportType()));
        dispute.setExtraDataMap(CollectionUtils.isEmpty(proto.getExtraDataMap()) ? null : ExtraDataMapValidator.getValidatedExtraDataMap(proto.getExtraDataMap()));
        dispute.chatMessages.addAll(proto.getChatMessageList().stream().map(ChatMessage::fromPayloadProto).collect(Collectors.toList()));
        if (proto.hasDisputeResult()) {
            dispute.disputeResultProperty.set(DisputeResult.fromProto(proto.getDisputeResult()));
        }
        dispute.disputePayoutTxId = ProtoUtil.stringOrNullFromProto(proto.getDisputePayoutTxId());
        String mediatorsDisputeResult = proto.getMediatorsDisputeResult();
        if (!mediatorsDisputeResult.isEmpty()) {
            dispute.setMediatorsDisputeResult(mediatorsDisputeResult);
        }
        if (!(delayedPayoutTxId = proto.getDelayedPayoutTxId()).isEmpty()) {
            dispute.setDelayedPayoutTxId(delayedPayoutTxId);
        }
        if (!(donationAddressOfDelayedPayoutTx = proto.getDonationAddressOfDelayedPayoutTx()).isEmpty()) {
            dispute.setDonationAddressOfDelayedPayoutTx(donationAddressOfDelayedPayoutTx);
        }
        if (State.fromProto(proto.getState()) == State.NEEDS_UPGRADE) {
            dispute.setState(proto.getIsClosed() ? State.CLOSED : State.OPEN);
            if (dispute.getDisputeState() == State.CLOSED) {
                dispute.getChatMessages().forEach(m4 -> m4.setWasDisplayed(true));
            }
        } else {
            dispute.setState(State.fromProto(proto.getState()));
        }
        dispute.refreshAlertLevel(true);
        return dispute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndPersistChatMessage(ChatMessage chatMessage) {
        ObservableList<ChatMessage> observableList = this.chatMessages;
        synchronized (observableList) {
            if (!this.chatMessages.contains(chatMessage)) {
                this.chatMessages.add(chatMessage);
            } else {
                log.error("disputeDirectMessage already exists");
            }
        }
    }

    public boolean isMediationDispute() {
        return !this.chatMessages.isEmpty() && ((ChatMessage)this.chatMessages.get(0)).getSupportType() == SupportType.MEDIATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllChatMessages() {
        ObservableList<ChatMessage> observableList = this.chatMessages;
        synchronized (observableList) {
            if (this.chatMessages.size() > 1) {
                String firstMessageUid = ((ChatMessage)this.chatMessages.get(0)).getUid();
                this.chatMessages.removeIf(msg -> !msg.getUid().equals(firstMessageUid));
                return true;
            }
            return false;
        }
    }

    public void maybeClearSensitiveData() {
        String edited;
        Object change = "";
        if (this.contract.maybeClearSensitiveData()) {
            change = (String)change + "contract;";
        }
        if (!(edited = Contract.sanitizeContractAsJson(this.contractAsJson)).equals(this.contractAsJson)) {
            this.contractAsJson = edited;
            change = (String)change + "contractAsJson;";
        }
        if (this.removeAllChatMessages()) {
            change = (String)change + "chat messages;";
        }
        if (((String)change).length() > 0) {
            log.info("cleared sensitive data from {} of dispute for trade {}", change, (Object)Utilities.getShortId(this.getTradeId()));
        }
    }

    public static String sanitizeContractAsJson(String contractAsJson) {
        return contractAsJson;
    }

    public void setIsClosed() {
        this.setState(State.CLOSED);
    }

    public void reOpen() {
        this.setState(State.REOPENED);
    }

    public void setState(State disputeState) {
        this.disputeState = disputeState;
        UserThread.execute(() -> this.isClosedProperty.set(disputeState == State.CLOSED));
    }

    public void setDisputeResult(DisputeResult disputeResult) {
        this.disputeResultProperty.set(disputeResult);
    }

    public void setExtraData(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (this.extraDataMap == null) {
            this.extraDataMap = new HashMap<String, String>();
        }
        this.extraDataMap.put(key, value);
    }

    public String getShortTradeId() {
        return Utilities.getShortId(this.tradeId);
    }

    public ReadOnlyBooleanProperty isClosedProperty() {
        return this.isClosedProperty;
    }

    public ReadOnlyIntegerProperty getBadgeCountProperty() {
        return this.badgeCountProperty;
    }

    public ReadOnlyObjectProperty<DisputeResult> disputeResultProperty() {
        return this.disputeResultProperty;
    }

    public Date getTradeDate() {
        return new Date(this.tradeDate);
    }

    public Date getTradePeriodEnd() {
        return new Date(this.tradePeriodEnd);
    }

    public Date getOpeningDate() {
        return new Date(this.openingDate);
    }

    public boolean isNew() {
        return this.disputeState == State.NEW;
    }

    public boolean isOpen() {
        return this.isNew() || this.disputeState == State.OPEN || this.disputeState == State.REOPENED;
    }

    public boolean isClosed() {
        return this.disputeState == State.CLOSED;
    }

    public void refreshAlertLevel(boolean senderFlag) {
        if (this.isNew() || this.unreadMessageCount(senderFlag) > 0L) {
            this.badgeCountProperty.setValue(1);
        } else {
            this.badgeCountProperty.setValue(0);
        }
    }

    public long unreadMessageCount(boolean senderFlag) {
        return this.chatMessages.stream().filter(m4 -> m4.isSenderIsTrader() == senderFlag || m4.isSystemMessage()).filter(m4 -> !m4.isWasDisplayed()).count();
    }

    public void setDisputeSeen(boolean senderFlag) {
        if (this.disputeState == State.NEW) {
            this.setState(State.OPEN);
        }
        this.refreshAlertLevel(senderFlag);
    }

    public void setChatMessagesSeen(boolean senderFlag) {
        this.getChatMessages().forEach(m4 -> m4.setWasDisplayed(true));
        this.refreshAlertLevel(senderFlag);
    }

    public String getRoleString() {
        if (this.disputeOpenerIsMaker) {
            if (this.disputeOpenerIsBuyer) {
                return Res.get(this.isOpener() ? "support.buyerMaker" : "support.sellerTaker");
            }
            return Res.get(this.isOpener() ? "support.sellerMaker" : "support.buyerTaker");
        }
        if (this.disputeOpenerIsBuyer) {
            return Res.get(this.isOpener() ? "support.buyerTaker" : "support.sellerMaker");
        }
        return Res.get(this.isOpener() ? "support.sellerTaker" : "support.buyerMaker");
    }

    public String getRoleStringForLogFile() {
        return (this.disputeOpenerIsBuyer ? "BUYER" : "SELLER") + "_" + (this.disputeOpenerIsMaker ? "MAKER" : "TAKER");
    }

    @Nullable
    public PaymentAccountPayload getBuyerPaymentAccountPayload() {
        return this.contract.isBuyerMakerAndSellerTaker() ? this.makerPaymentAccountPayload : this.takerPaymentAccountPayload;
    }

    @Nullable
    public PaymentAccountPayload getSellerPaymentAccountPayload() {
        return this.contract.isBuyerMakerAndSellerTaker() ? this.takerPaymentAccountPayload : this.makerPaymentAccountPayload;
    }

    public String toString() {
        return "Dispute{\n     tradeId='" + this.tradeId + "',\n     id='" + this.id + "',\n     uid='" + this.uid + "',\n     state=" + String.valueOf((Object)this.disputeState) + ",\n     traderId=" + this.traderId + ",\n     isOpener=" + this.isOpener + ",\n     disputeOpenerIsBuyer=" + this.disputeOpenerIsBuyer + ",\n     disputeOpenerIsMaker=" + this.disputeOpenerIsMaker + ",\n     traderPubKeyRing=" + String.valueOf(this.traderPubKeyRing) + ",\n     tradeDate=" + this.tradeDate + ",\n     tradePeriodEnd=" + this.tradePeriodEnd + ",\n     contract=" + String.valueOf(this.contract) + ",\n     contractHash=" + Utilities.bytesAsHexString(this.contractHash) + ",\n     payoutTxSerialized=" + Utilities.bytesAsHexString(this.payoutTxSerialized) + ",\n     payoutTxId='" + this.payoutTxId + "',\n     contractAsJson='" + this.contractAsJson + "',\n     makerContractSignature='" + Utilities.bytesAsHexString(this.makerContractSignature) + "',\n     takerContractSignature='" + Utilities.bytesAsHexString(this.takerContractSignature) + "',\n     agentPubKeyRing=" + String.valueOf(this.agentPubKeyRing) + ",\n     isSupportTicket=" + this.isSupportTicket + ",\n     chatMessages=" + String.valueOf(this.chatMessages) + ",\n     isClosedProperty=" + String.valueOf(this.isClosedProperty) + ",\n     disputeResultProperty=" + String.valueOf(this.disputeResultProperty) + ",\n     disputePayoutTxId='" + this.disputePayoutTxId + "',\n     openingDate=" + this.openingDate + ",\n     supportType=" + String.valueOf((Object)this.supportType) + ",\n     mediatorsDisputeResult='" + this.mediatorsDisputeResult + "',\n     delayedPayoutTxId='" + this.delayedPayoutTxId + "',\n     donationAddressOfDelayedPayoutTx='" + this.donationAddressOfDelayedPayoutTx + "',\n     makerPaymentAccountPayload='" + String.valueOf(this.makerPaymentAccountPayload) + "',\n     takerPaymentAccountPayload='" + String.valueOf(this.takerPaymentAccountPayload) + "'\n}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (this.getTraderId() != other.getTraderId()) {
            return false;
        }
        if (this.isDisputeOpenerIsBuyer() != other.isDisputeOpenerIsBuyer()) {
            return false;
        }
        if (this.isDisputeOpenerIsMaker() != other.isDisputeOpenerIsMaker()) {
            return false;
        }
        Date this$tradeDate = this.getTradeDate();
        Date other$tradeDate = other.getTradeDate();
        if (this$tradeDate == null ? other$tradeDate != null : !((Object)this$tradeDate).equals(other$tradeDate)) {
            return false;
        }
        Date this$tradePeriodEnd = this.getTradePeriodEnd();
        Date other$tradePeriodEnd = other.getTradePeriodEnd();
        if (this$tradePeriodEnd == null ? other$tradePeriodEnd != null : !((Object)this$tradePeriodEnd).equals(other$tradePeriodEnd)) {
            return false;
        }
        if (this.isSupportTicket() != other.isSupportTicket()) {
            return false;
        }
        Date this$openingDate = this.getOpeningDate();
        Date other$openingDate = other.getOpeningDate();
        if (this$openingDate == null ? other$openingDate != null : !((Object)this$openingDate).equals(other$openingDate)) {
            return false;
        }
        if (this.isOpener() != other.isOpener()) {
            return false;
        }
        String this$tradeId = this.getTradeId();
        String other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !this$tradeId.equals(other$tradeId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PubKeyRing this$traderPubKeyRing = this.getTraderPubKeyRing();
        PubKeyRing other$traderPubKeyRing = other.getTraderPubKeyRing();
        if (this$traderPubKeyRing == null ? other$traderPubKeyRing != null : !((Object)this$traderPubKeyRing).equals(other$traderPubKeyRing)) {
            return false;
        }
        Contract this$contract = this.getContract();
        Contract other$contract = other.getContract();
        if (this$contract == null ? other$contract != null : !((Object)this$contract).equals(other$contract)) {
            return false;
        }
        if (!Arrays.equals(this.getContractHash(), other.getContractHash())) {
            return false;
        }
        if (!Arrays.equals(this.getPayoutTxSerialized(), other.getPayoutTxSerialized())) {
            return false;
        }
        String this$payoutTxId = this.getPayoutTxId();
        String other$payoutTxId = other.getPayoutTxId();
        if (this$payoutTxId == null ? other$payoutTxId != null : !this$payoutTxId.equals(other$payoutTxId)) {
            return false;
        }
        String this$contractAsJson = this.getContractAsJson();
        String other$contractAsJson = other.getContractAsJson();
        if (this$contractAsJson == null ? other$contractAsJson != null : !this$contractAsJson.equals(other$contractAsJson)) {
            return false;
        }
        if (!Arrays.equals(this.getMakerContractSignature(), other.getMakerContractSignature())) {
            return false;
        }
        if (!Arrays.equals(this.getTakerContractSignature(), other.getTakerContractSignature())) {
            return false;
        }
        PubKeyRing this$agentPubKeyRing = this.getAgentPubKeyRing();
        PubKeyRing other$agentPubKeyRing = other.getAgentPubKeyRing();
        if (this$agentPubKeyRing == null ? other$agentPubKeyRing != null : !((Object)this$agentPubKeyRing).equals(other$agentPubKeyRing)) {
            return false;
        }
        ObservableList<ChatMessage> this$chatMessages = this.getChatMessages();
        ObservableList<ChatMessage> other$chatMessages = other.getChatMessages();
        if (this$chatMessages == null ? other$chatMessages != null : !this$chatMessages.equals(other$chatMessages)) {
            return false;
        }
        ObjectProperty<DisputeResult> this$disputeResultProperty = this.getDisputeResultProperty();
        ObjectProperty<DisputeResult> other$disputeResultProperty = other.getDisputeResultProperty();
        if (this$disputeResultProperty == null ? other$disputeResultProperty != null : !this$disputeResultProperty.equals(other$disputeResultProperty)) {
            return false;
        }
        String this$disputePayoutTxId = this.getDisputePayoutTxId();
        String other$disputePayoutTxId = other.getDisputePayoutTxId();
        if (this$disputePayoutTxId == null ? other$disputePayoutTxId != null : !this$disputePayoutTxId.equals(other$disputePayoutTxId)) {
            return false;
        }
        SupportType this$supportType = this.getSupportType();
        SupportType other$supportType = other.getSupportType();
        if (this$supportType == null ? other$supportType != null : !((Object)((Object)this$supportType)).equals((Object)other$supportType)) {
            return false;
        }
        String this$mediatorsDisputeResult = this.getMediatorsDisputeResult();
        String other$mediatorsDisputeResult = other.getMediatorsDisputeResult();
        if (this$mediatorsDisputeResult == null ? other$mediatorsDisputeResult != null : !this$mediatorsDisputeResult.equals(other$mediatorsDisputeResult)) {
            return false;
        }
        String this$delayedPayoutTxId = this.getDelayedPayoutTxId();
        String other$delayedPayoutTxId = other.getDelayedPayoutTxId();
        if (this$delayedPayoutTxId == null ? other$delayedPayoutTxId != null : !this$delayedPayoutTxId.equals(other$delayedPayoutTxId)) {
            return false;
        }
        String this$donationAddressOfDelayedPayoutTx = this.getDonationAddressOfDelayedPayoutTx();
        String other$donationAddressOfDelayedPayoutTx = other.getDonationAddressOfDelayedPayoutTx();
        if (this$donationAddressOfDelayedPayoutTx == null ? other$donationAddressOfDelayedPayoutTx != null : !this$donationAddressOfDelayedPayoutTx.equals(other$donationAddressOfDelayedPayoutTx)) {
            return false;
        }
        State this$disputeState = this.getDisputeState();
        State other$disputeState = other.getDisputeState();
        if (this$disputeState == null ? other$disputeState != null : !((Object)((Object)this$disputeState)).equals((Object)other$disputeState)) {
            return false;
        }
        Map<String, String> this$extraDataMap = this.getExtraDataMap();
        Map<String, String> other$extraDataMap = other.getExtraDataMap();
        if (this$extraDataMap == null ? other$extraDataMap != null : !((Object)this$extraDataMap).equals(other$extraDataMap)) {
            return false;
        }
        PaymentAccountPayload this$makerPaymentAccountPayload = this.getMakerPaymentAccountPayload();
        PaymentAccountPayload other$makerPaymentAccountPayload = other.getMakerPaymentAccountPayload();
        if (this$makerPaymentAccountPayload == null ? other$makerPaymentAccountPayload != null : !((Object)this$makerPaymentAccountPayload).equals(other$makerPaymentAccountPayload)) {
            return false;
        }
        PaymentAccountPayload this$takerPaymentAccountPayload = this.getTakerPaymentAccountPayload();
        PaymentAccountPayload other$takerPaymentAccountPayload = other.getTakerPaymentAccountPayload();
        return !(this$takerPaymentAccountPayload == null ? other$takerPaymentAccountPayload != null : !((Object)this$takerPaymentAccountPayload).equals(other$takerPaymentAccountPayload));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTraderId();
        result = result * 59 + (this.isDisputeOpenerIsBuyer() ? 79 : 97);
        result = result * 59 + (this.isDisputeOpenerIsMaker() ? 79 : 97);
        Date $tradeDate = this.getTradeDate();
        result = result * 59 + ($tradeDate == null ? 43 : ((Object)$tradeDate).hashCode());
        Date $tradePeriodEnd = this.getTradePeriodEnd();
        result = result * 59 + ($tradePeriodEnd == null ? 43 : ((Object)$tradePeriodEnd).hashCode());
        result = result * 59 + (this.isSupportTicket() ? 79 : 97);
        Date $openingDate = this.getOpeningDate();
        result = result * 59 + ($openingDate == null ? 43 : ((Object)$openingDate).hashCode());
        result = result * 59 + (this.isOpener() ? 79 : 97);
        String $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : $tradeId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PubKeyRing $traderPubKeyRing = this.getTraderPubKeyRing();
        result = result * 59 + ($traderPubKeyRing == null ? 43 : ((Object)$traderPubKeyRing).hashCode());
        Contract $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : ((Object)$contract).hashCode());
        result = result * 59 + Arrays.hashCode(this.getContractHash());
        result = result * 59 + Arrays.hashCode(this.getPayoutTxSerialized());
        String $payoutTxId = this.getPayoutTxId();
        result = result * 59 + ($payoutTxId == null ? 43 : $payoutTxId.hashCode());
        String $contractAsJson = this.getContractAsJson();
        result = result * 59 + ($contractAsJson == null ? 43 : $contractAsJson.hashCode());
        result = result * 59 + Arrays.hashCode(this.getMakerContractSignature());
        result = result * 59 + Arrays.hashCode(this.getTakerContractSignature());
        PubKeyRing $agentPubKeyRing = this.getAgentPubKeyRing();
        result = result * 59 + ($agentPubKeyRing == null ? 43 : ((Object)$agentPubKeyRing).hashCode());
        ObservableList<ChatMessage> $chatMessages = this.getChatMessages();
        result = result * 59 + ($chatMessages == null ? 43 : $chatMessages.hashCode());
        ObjectProperty<DisputeResult> $disputeResultProperty = this.getDisputeResultProperty();
        result = result * 59 + ($disputeResultProperty == null ? 43 : $disputeResultProperty.hashCode());
        String $disputePayoutTxId = this.getDisputePayoutTxId();
        result = result * 59 + ($disputePayoutTxId == null ? 43 : $disputePayoutTxId.hashCode());
        SupportType $supportType = this.getSupportType();
        result = result * 59 + ($supportType == null ? 43 : ((Object)((Object)$supportType)).hashCode());
        String $mediatorsDisputeResult = this.getMediatorsDisputeResult();
        result = result * 59 + ($mediatorsDisputeResult == null ? 43 : $mediatorsDisputeResult.hashCode());
        String $delayedPayoutTxId = this.getDelayedPayoutTxId();
        result = result * 59 + ($delayedPayoutTxId == null ? 43 : $delayedPayoutTxId.hashCode());
        String $donationAddressOfDelayedPayoutTx = this.getDonationAddressOfDelayedPayoutTx();
        result = result * 59 + ($donationAddressOfDelayedPayoutTx == null ? 43 : $donationAddressOfDelayedPayoutTx.hashCode());
        State $disputeState = this.getDisputeState();
        result = result * 59 + ($disputeState == null ? 43 : ((Object)((Object)$disputeState)).hashCode());
        Map<String, String> $extraDataMap = this.getExtraDataMap();
        result = result * 59 + ($extraDataMap == null ? 43 : ((Object)$extraDataMap).hashCode());
        PaymentAccountPayload $makerPaymentAccountPayload = this.getMakerPaymentAccountPayload();
        result = result * 59 + ($makerPaymentAccountPayload == null ? 43 : ((Object)$makerPaymentAccountPayload).hashCode());
        PaymentAccountPayload $takerPaymentAccountPayload = this.getTakerPaymentAccountPayload();
        result = result * 59 + ($takerPaymentAccountPayload == null ? 43 : ((Object)$takerPaymentAccountPayload).hashCode());
        return result;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public String getId() {
        return this.id;
    }

    public int getTraderId() {
        return this.traderId;
    }

    public boolean isDisputeOpenerIsBuyer() {
        return this.disputeOpenerIsBuyer;
    }

    public boolean isDisputeOpenerIsMaker() {
        return this.disputeOpenerIsMaker;
    }

    public PubKeyRing getTraderPubKeyRing() {
        return this.traderPubKeyRing;
    }

    public Contract getContract() {
        return this.contract;
    }

    @Nullable
    public byte[] getContractHash() {
        return this.contractHash;
    }

    @Nullable
    public byte[] getPayoutTxSerialized() {
        return this.payoutTxSerialized;
    }

    @Nullable
    public String getPayoutTxId() {
        return this.payoutTxId;
    }

    public String getContractAsJson() {
        return this.contractAsJson;
    }

    @Nullable
    public byte[] getMakerContractSignature() {
        return this.makerContractSignature;
    }

    @Nullable
    public byte[] getTakerContractSignature() {
        return this.takerContractSignature;
    }

    public PubKeyRing getAgentPubKeyRing() {
        return this.agentPubKeyRing;
    }

    public boolean isSupportTicket() {
        return this.isSupportTicket;
    }

    public ObservableList<ChatMessage> getChatMessages() {
        return this.chatMessages;
    }

    public ObjectProperty<DisputeResult> getDisputeResultProperty() {
        return this.disputeResultProperty;
    }

    @Nullable
    public String getDisputePayoutTxId() {
        return this.disputePayoutTxId;
    }

    public SupportType getSupportType() {
        return this.supportType;
    }

    @Nullable
    public String getMediatorsDisputeResult() {
        return this.mediatorsDisputeResult;
    }

    @Nullable
    public String getDelayedPayoutTxId() {
        return this.delayedPayoutTxId;
    }

    @Nullable
    public String getDonationAddressOfDelayedPayoutTx() {
        return this.donationAddressOfDelayedPayoutTx;
    }

    public State getDisputeState() {
        return this.disputeState;
    }

    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    public boolean isOpener() {
        return this.isOpener;
    }

    @Nullable
    public PaymentAccountPayload getMakerPaymentAccountPayload() {
        return this.makerPaymentAccountPayload;
    }

    @Nullable
    public PaymentAccountPayload getTakerPaymentAccountPayload() {
        return this.takerPaymentAccountPayload;
    }

    @Nullable
    public String getUid() {
        return this.uid;
    }

    public long getPayoutTxConfirms() {
        return this.payoutTxConfirms;
    }

    public BooleanProperty getIsClosedProperty() {
        return this.isClosedProperty;
    }

    public FileTransferReceiver getFileTransferSession() {
        return this.fileTransferSession;
    }

    public void setDisputePayoutTxId(@Nullable String disputePayoutTxId) {
        this.disputePayoutTxId = disputePayoutTxId;
    }

    public void setSupportType(SupportType supportType) {
        this.supportType = supportType;
    }

    public void setMediatorsDisputeResult(@Nullable String mediatorsDisputeResult) {
        this.mediatorsDisputeResult = mediatorsDisputeResult;
    }

    public void setDelayedPayoutTxId(@Nullable String delayedPayoutTxId) {
        this.delayedPayoutTxId = delayedPayoutTxId;
    }

    public void setDonationAddressOfDelayedPayoutTx(@Nullable String donationAddressOfDelayedPayoutTx) {
        this.donationAddressOfDelayedPayoutTx = donationAddressOfDelayedPayoutTx;
    }

    public void setExtraDataMap(@Nullable Map<String, String> extraDataMap) {
        this.extraDataMap = extraDataMap;
    }

    public void setUid(@Nullable String uid) {
        this.uid = uid;
    }

    public void setPayoutTxConfirms(long payoutTxConfirms) {
        this.payoutTxConfirms = payoutTxConfirms;
    }

    public static enum State {
        NEEDS_UPGRADE,
        NEW,
        OPEN,
        REOPENED,
        CLOSED;


        public boolean isOpen() {
            return this == NEW || this == OPEN || this == REOPENED;
        }

        public static State fromProto(Dispute.State state) {
            return ProtoUtil.enumFromProto(State.class, state.name());
        }

        public static Dispute.State toProtoMessage(State state) {
            return Dispute.State.valueOf(state.name());
        }
    }
}

